/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.plugins;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jboss.forge.addon.maven.plugins.Configuration;
import org.jboss.forge.addon.maven.plugins.ConfigurationElement;
import org.jboss.forge.addon.maven.plugins.ConfigurationElementBuilder;

public class ConfigurationImpl
implements Configuration {
    private final Xpp3Dom configuration;
    private final List<ConfigurationElement> configurationElements = new ArrayList<ConfigurationElement>();

    public ConfigurationImpl() {
        this.configuration = new Xpp3Dom("configuration");
    }

    public ConfigurationImpl(Xpp3Dom configXml) {
        this.configuration = configXml;
        if (this.configuration != null) {
            for (Xpp3Dom xpp3Dom : this.configuration.getChildren()) {
                ConfigurationElementBuilder builder = ConfigurationElementBuilder.create().setName(xpp3Dom.getName()).setText(xpp3Dom.getValue());
                this.addChildren(xpp3Dom, builder);
                this.configurationElements.add(builder);
            }
        }
    }

    @Override
    public ConfigurationElement getConfigurationElement(String configElement) {
        for (ConfigurationElement configurationElement : this.configurationElements) {
            if (!configurationElement.getName().equals(configElement)) continue;
            return configurationElement;
        }
        throw new RuntimeException("Configuration '" + configElement + "' not found");
    }

    @Override
    public boolean hasConfigurationElement(String configElement) {
        for (ConfigurationElement configurationElement : this.configurationElements) {
            if (!configurationElement.getName().equals(configElement)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasConfigurationElements() {
        return !this.listConfigurationElements().isEmpty();
    }

    @Override
    public List<ConfigurationElement> listConfigurationElements() {
        return this.configurationElements;
    }

    private void addChildren(Xpp3Dom xpp3Dom, ConfigurationElementBuilder builder) {
        builder.setText(xpp3Dom.getValue());
        for (String string : xpp3Dom.getAttributeNames()) {
            String attributeValue = xpp3Dom.getAttribute(string);
            if (attributeValue == null) continue;
            builder.addAttribute(string, attributeValue);
        }
        for (String string : xpp3Dom.getChildren()) {
            ConfigurationElementBuilder elementBuilder = builder.addChild(string.getName());
            this.addChildren((Xpp3Dom)string, elementBuilder);
        }
    }

    @Override
    public Configuration addConfigurationElement(ConfigurationElement element) {
        this.configurationElements.add(element);
        return this;
    }

    @Override
    public void removeConfigurationElement(String elementName) {
        for (ConfigurationElement configurationElement : this.configurationElements) {
            if (!configurationElement.getName().equals(elementName)) continue;
            this.configurationElements.remove(configurationElement);
            break;
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("<configuration>");
        for (ConfigurationElement configurationElement : this.configurationElements) {
            b.append(configurationElement.toString());
        }
        b.append("</configuration>");
        return b.toString();
    }
}

