/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openrdf.rio.DatatypeHandler;
import org.openrdf.rio.DatatypeHandlerRegistry;
import org.openrdf.rio.LanguageHandler;
import org.openrdf.rio.LanguageHandlerRegistry;
import org.openrdf.rio.RioSetting;
import org.openrdf.rio.helpers.LargeLiteralHandling;
import org.openrdf.rio.helpers.RioSettingImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicParserSettings {
    private static final Logger log = LoggerFactory.getLogger(BasicParserSettings.class);
    public static final RioSetting<Boolean> VERIFY_DATATYPE_VALUES = new RioSettingImpl<Boolean>("org.openrdf.rio.verifydatatypevalues", "Verify recognised datatype values", Boolean.TRUE);
    public static final RioSetting<Boolean> FAIL_ON_UNKNOWN_DATATYPES = new RioSettingImpl<Boolean>("org.openrdf.rio.failonunknowndatatypes", "Fail on unknown datatypes", Boolean.FALSE);
    public static final RioSetting<Boolean> NORMALIZE_DATATYPE_VALUES = new RioSettingImpl<Boolean>("org.openrdf.rio.normalizedatatypevalues", "Normalize recognised datatype values", Boolean.FALSE);
    public static final RioSetting<List<DatatypeHandler>> DATATYPE_HANDLERS;
    public static final RioSetting<Boolean> FAIL_ON_UNKNOWN_LANGUAGES;
    public static final RioSetting<Boolean> VERIFY_LANGUAGE_TAGS;
    public static final RioSetting<Boolean> NORMALIZE_LANGUAGE_TAGS;
    public static final RioSetting<List<LanguageHandler>> LANGUAGE_HANDLERS;
    public static final RioSetting<Boolean> VERIFY_RELATIVE_URIS;
    public static final RioSetting<Boolean> PRESERVE_BNODE_IDS;
    public static final RioSetting<LargeLiteralHandling> LARGE_LITERALS_HANDLING;
    public static final RioSetting<Long> LARGE_LITERALS_LIMIT;

    private BasicParserSettings() {
    }

    static {
        FAIL_ON_UNKNOWN_LANGUAGES = new RioSettingImpl<Boolean>("org.openrdf.rio.failonunknownlanguages", "Fail on unknown languages", Boolean.FALSE);
        VERIFY_LANGUAGE_TAGS = new RioSettingImpl<Boolean>("org.openrdf.rio.verifylanguagevalues", "Verify language tags", Boolean.TRUE);
        NORMALIZE_LANGUAGE_TAGS = new RioSettingImpl<Boolean>("org.openrdf.rio.normalizedatatypevalues", "Normalize recognised datatype values", Boolean.FALSE);
        VERIFY_RELATIVE_URIS = new RioSettingImpl<Boolean>("org.openrdf.rio.verifyrelativeuris", "Verify relative URIs", Boolean.TRUE);
        PRESERVE_BNODE_IDS = new RioSettingImpl<Boolean>("org.openrdf.rio.preservebnodeids", "Preserve blank node identifiers", Boolean.FALSE);
        LARGE_LITERALS_HANDLING = new RioSettingImpl<LargeLiteralHandling>("org.openrdf.rio.largeliterals", "Large literals handling", LargeLiteralHandling.PRESERVE);
        LARGE_LITERALS_LIMIT = new RioSettingImpl<Long>("org.openrdf.rio.largeliteralslimit", "Size limit for large literals", 0x100000L);
        ArrayList<DatatypeHandler> defaultDatatypeHandlers = new ArrayList<DatatypeHandler>(4);
        try {
            DatatypeHandlerRegistry registry = DatatypeHandlerRegistry.getInstance();
            for (String nextHandler : Arrays.asList("org.openrdf.rio.datatypes.xmlschema", "org.openrdf.rio.datatypes.rdf", "org.openrdf.rio.datatypes.dbpedia", "org.openrdf.rio.datatypes.virtuosogeometry", "org.openrdf.rio.datatypes.geosparql")) {
                DatatypeHandler nextdt = (DatatypeHandler)registry.get(nextHandler);
                if (nextdt != null) {
                    defaultDatatypeHandlers.add(nextdt);
                    continue;
                }
                log.warn("Could not find DatatypeHandler : {}", (Object)nextHandler);
            }
        }
        catch (Exception e) {
            log.warn("Found an error loading DatatypeHandler services", (Throwable)e);
        }
        DATATYPE_HANDLERS = new RioSettingImpl("org.openrdf.rio.datatypehandlers", "Datatype Handlers", defaultDatatypeHandlers);
        ArrayList<LanguageHandler> defaultLanguageHandlers = new ArrayList<LanguageHandler>(1);
        try {
            LanguageHandlerRegistry registry = LanguageHandlerRegistry.getInstance();
            for (String nextHandler : Arrays.asList("org.openrdf.rio.languages.RFC3066")) {
                LanguageHandler nextlang = (LanguageHandler)registry.get(nextHandler);
                if (nextlang != null) {
                    defaultLanguageHandlers.add(nextlang);
                    continue;
                }
                log.warn("Could not find LanguageHandler : {}", (Object)nextHandler);
            }
        }
        catch (Exception e) {
            log.warn("Found an error loading LanguageHandler services", (Throwable)e);
        }
        LANGUAGE_HANDLERS = new RioSettingImpl("org.openrdf.rio.languagehandlers", "Language Handlers", defaultLanguageHandlers);
    }
}

