/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.archives;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.logging.Logger;
import org.apache.commons.collections4.list.TreeList;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.Version;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.Indexer;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexUtils;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.updater.IndexUpdateRequest;
import org.apache.maven.index.updater.IndexUpdateResult;
import org.apache.maven.index.updater.IndexUpdater;
import org.apache.maven.index.updater.ResourceFetcher;
import org.apache.maven.index.updater.WagonHelper;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.events.TransferListener;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.jboss.forge.addon.dependencies.DependencyRepository;
import org.jboss.windup.rules.apps.java.archives.LoggingTransferListener;

public class RepositoryIndexManager
implements AutoCloseable {
    private static final Logger log = Logger.getLogger(RepositoryIndexManager.class.getName());
    private File indexDirectory;
    private final PlexusContainer plexusContainer;
    private final Indexer indexer;
    private final IndexUpdater indexUpdater;
    private final Wagon httpWagon;
    private final IndexingContext context;
    private final File localCache;
    private final File indexDir;

    public static void generateMetadata(DependencyRepository repository, File indexDir, File outputDir) throws Exception {
        try (RepositoryIndexManager manager = new RepositoryIndexManager(indexDir, repository);){
            log.info("Downloading or updating index into " + indexDir.getPath());
            manager.downloadIndexAndUpdate();
            outputDir.mkdirs();
            File metadataFile = RepositoryIndexManager.getMetadataFile(repository, outputDir);
            try (FileWriter out = new FileWriter(metadataFile);){
                log.info("Writing sorted metadata to " + metadataFile.getPath());
                manager.writeMetadataTo(outputDir, out);
            }
        }
    }

    public static boolean metadataExists(DependencyRepository repository, File outputDir) {
        return RepositoryIndexManager.getMetadataFile(repository, outputDir).exists();
    }

    public static File getMetadataFile(DependencyRepository repository, File outputDir) {
        return new File(outputDir, repository.getId() + ".archive-metadata" + ".txt");
    }

    private RepositoryIndexManager(File indexDirectory, DependencyRepository repository) throws PlexusContainerException, ComponentLookupException, IOException {
        boolean updateExistingIndex = true;
        this.indexDirectory = indexDirectory;
        DefaultContainerConfiguration config = new DefaultContainerConfiguration();
        config.setClassPathScanning("index");
        this.plexusContainer = new DefaultPlexusContainer((ContainerConfiguration)config);
        this.indexer = (Indexer)this.plexusContainer.lookup(Indexer.class);
        this.indexUpdater = (IndexUpdater)this.plexusContainer.lookup(IndexUpdater.class);
        this.httpWagon = (Wagon)this.plexusContainer.lookup(Wagon.class, "http");
        this.localCache = new File(this.indexDirectory, repository.getId() + "-cache");
        this.indexDir = new File(this.indexDirectory, repository.getId() + "-index");
        ArrayList<Object> indexers = new ArrayList<Object>();
        indexers.add(this.plexusContainer.lookup(IndexCreator.class, "min"));
        this.context = this.indexer.createIndexingContext(repository.getId() + "Context", repository.getId(), this.localCache, this.indexDir, repository.getUrl(), null, true, true, indexers);
    }

    private void downloadIndexAndUpdate() throws IOException {
        WagonHelper.WagonFetcher resourceFetcher = new WagonHelper.WagonFetcher(this.httpWagon, (TransferListener)new LoggingTransferListener(log), null, null);
        IndexUpdateRequest updateRequest = new IndexUpdateRequest(this.context, (ResourceFetcher)resourceFetcher);
        updateRequest.setIncrementalOnly(false);
        updateRequest.setForceFullUpdate(false);
        IndexUpdateResult updateResult = this.indexUpdater.fetchAndUpdateIndex(updateRequest);
        if (updateResult.isFullUpdate()) {
            log.info("Fully updated index for repository [" + this.context.getId() + "] - [" + this.context.getRepositoryUrl() + "]");
        } else {
            log.info("Incrementally updated index for repository [" + this.context.getId() + "] - [" + this.context.getRepositoryUrl() + "]");
        }
    }

    private void writeMetadataTo(File outputDirectory, FileWriter writer) throws IOException {
        File outputLuceneDirectory = new File(outputDirectory, "lucene");
        outputLuceneDirectory.mkdirs();
        File markerFile = new File(outputLuceneDirectory, "archive-metadata.lucene.marker");
        markerFile.createNewFile();
        SimpleFSDirectory output = new SimpleFSDirectory(outputLuceneDirectory);
        StandardAnalyzer standardAnalyzer = new StandardAnalyzer(Version.LUCENE_48);
        IndexWriterConfig config = new IndexWriterConfig(Version.LUCENE_48, (Analyzer)standardAnalyzer);
        try (IndexWriter indexWriter = new IndexWriter((Directory)output, config);){
            IndexSearcher searcher = this.context.acquireIndexSearcher();
            IndexReader reader = searcher.getIndexReader();
            Bits liveDocs = MultiFields.getLiveDocs((IndexReader)reader);
            String SKIPPED = "javadoc javadocs docs source sources test tests test-sources tests-sources test-javadoc tests-javadoc";
            HashSet<String> skippedClassifiers = new HashSet<String>(Arrays.asList("javadoc javadocs docs source sources test tests test-sources tests-sources test-javadoc tests-javadoc".split(" ")));
            TreeList lines = new TreeList();
            for (int i = 0; i < reader.maxDoc(); ++i) {
                Document doc;
                ArtifactInfo info;
                if (liveDocs != null && !liveDocs.get(i) || (info = IndexUtils.constructArtifactInfo((Document)(doc = reader.document(i)), (IndexingContext)this.context)) == null || info.getSha1() == null || info.getSha1().length() != 40 || "tests".equals(info.getArtifactId()) || "pom".equals(info.getPackaging()) || skippedClassifiers.contains(info.getClassifier())) continue;
                StringBuilder line = new StringBuilder();
                String sha1 = StringUtils.lowerCase((String)info.getSha1());
                String packaging = StringUtils.defaultString((String)info.getPackaging());
                String classifier = StringUtils.defaultString((String)info.getClassifier());
                Document outputDoc = new Document();
                outputDoc.add((IndexableField)new StringField("sha1", sha1, Field.Store.YES));
                outputDoc.add((IndexableField)new StringField("groupId", info.getGroupId(), Field.Store.YES));
                outputDoc.add((IndexableField)new StringField("artifactId", info.getArtifactId(), Field.Store.YES));
                outputDoc.add((IndexableField)new StringField("packaging", packaging, Field.Store.YES));
                outputDoc.add((IndexableField)new StringField("classifier", classifier, Field.Store.YES));
                outputDoc.add((IndexableField)new StringField("version", info.getVersion(), Field.Store.YES));
                indexWriter.addDocument((Iterable)outputDoc);
                line.append(sha1).append(' ');
                line.append(info.getGroupId()).append(":");
                line.append(info.getArtifactId()).append(":");
                line.append(packaging).append(":");
                line.append(classifier).append(":");
                line.append(info.getVersion());
                line.append("\n");
                lines.add(line.toString());
            }
            Collections.sort(lines);
            for (String line : lines) {
                writer.append(line);
            }
        }
        output.close();
    }

    @Override
    public void close() throws IOException {
        this.context.close(false);
        this.indexer.closeIndexingContext(this.context, false);
    }
}

