/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.tattletale;

import java.util.HashMap;
import java.util.logging.Logger;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.ReportGenerationPhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.reporting.model.ApplicationReportModel;
import org.jboss.windup.reporting.model.ReportModel;
import org.jboss.windup.reporting.model.TemplateType;
import org.jboss.windup.reporting.service.ApplicationReportService;
import org.jboss.windup.reporting.service.ReportService;
import org.jboss.windup.util.Logging;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class CreateTattletaleReportLinkRuleProvider
extends AbstractRuleProvider {
    private static final Logger LOG = Logging.get(CreateTattletaleReportLinkRuleProvider.class);
    public static final String REPORT_TEMPLATE = "/reports/templates/embedded.ftl";
    private static final String TATTLETALE_INDEX_HTML = "tattletale/index.html";

    public CreateTattletaleReportLinkRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(CreateTattletaleReportLinkRuleProvider.class).setPhase(ReportGenerationPhase.class));
    }

    public Configuration getConfiguration(GraphContext context) {
        return ConfigurationBuilder.begin().addRule().perform((Operation)new CreateTattletaleReportModelOperation());
    }

    private class CreateTattletaleReportModelOperation
    extends GraphOperation {
        private CreateTattletaleReportModelOperation() {
        }

        public void perform(GraphRewrite event, EvaluationContext context) {
            WindupConfigurationModel cfg = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext());
            FileModel inputFM = cfg.getInputPath();
            ProjectModel inputProjectModel = inputFM.getProjectModel();
            ApplicationReportModel applicationReportModel = new ApplicationReportService(event.getGraphContext()).create();
            applicationReportModel.setReportName("Tattletale");
            applicationReportModel.setReportIconClass("glyphicon tattletale-nav-logo");
            applicationReportModel.setReportPriority(500);
            applicationReportModel.setDisplayInApplicationReportIndex(Boolean.valueOf(true));
            applicationReportModel.setProjectModel(inputProjectModel);
            applicationReportModel.setReportFilename(CreateTattletaleReportLinkRuleProvider.TATTLETALE_INDEX_HTML);
            applicationReportModel.setTemplatePath(CreateTattletaleReportLinkRuleProvider.REPORT_TEMPLATE);
            applicationReportModel.setTemplateType(TemplateType.FREEMARKER);
            HashMap<String, String> reportProperties = new HashMap<String, String>();
            reportProperties.put("embeddedTitle", "Tattletale Report");
            reportProperties.put("embeddedUrl", CreateTattletaleReportLinkRuleProvider.TATTLETALE_INDEX_HTML);
            applicationReportModel.setReportProperties(reportProperties);
            LOG.info("Title: " + (String)applicationReportModel.getReportProperties().get("embeddedTitle"));
            LOG.info("URL: " + (String)applicationReportModel.getReportProperties().get("embeddedUrl"));
            ReportService reportService = new ReportService(event.getGraphContext());
            reportService.setUniqueFilename((ReportModel)applicationReportModel, "tattletale_" + inputProjectModel.getName(), "html");
        }
    }
}

