/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.service;

import java.util.StringTokenizer;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;

public class ArchiveService
extends GraphService<ArchiveModel> {
    public ArchiveService(GraphContext context) {
        super(context, ArchiveModel.class);
    }

    public FileModel getChildFile(ArchiveModel archiveModel, String filePath) {
        StringTokenizer stk = new StringTokenizer(filePath, "/");
        FileModel currentFileModel = archiveModel.getUnzippedDirectory();
        while (stk.hasMoreTokens() && currentFileModel != null) {
            String pathElement = stk.nextToken();
            currentFileModel = this.findFileModel(currentFileModel, pathElement);
        }
        return currentFileModel;
    }

    private FileModel findFileModel(FileModel fm, String pathElement) {
        FileModel result = null;
        for (FileModel child : fm.getFilesInDirectory()) {
            if (!child.getFileName().equals(pathElement)) continue;
            result = child;
            break;
        }
        return result;
    }
}

