/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.projects.archetype.ui;

import com.google.common.base.Strings;
import java.io.PrintStream;
import java.net.URL;
import javax.inject.Inject;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.jboss.forge.addon.configuration.Configuration;
import org.jboss.forge.addon.configuration.Subset;
import org.jboss.forge.addon.maven.archetype.ArchetypeCatalogFactory;
import org.jboss.forge.addon.maven.archetype.ArchetypeCatalogFactoryRegistry;
import org.jboss.forge.addon.resource.URLResource;
import org.jboss.forge.addon.ui.annotation.Command;
import org.jboss.forge.addon.ui.annotation.Option;
import org.jboss.forge.addon.ui.annotation.predicate.NonGUIEnabledPredicate;
import org.jboss.forge.addon.ui.output.UIOutput;

public class ArchetypeCatalogCommands {
    @Inject
    @Subset(value="maven.archetypes")
    private Configuration configuration;
    @Inject
    private ArchetypeCatalogFactoryRegistry archetypeRegistry;

    @Command(value="Archetype: Add", categories={"Maven"}, help="Adds an archetype catalog to the Forge configuration file")
    public void addArchetype(@Option(value="named", label="Archetype catalog Name", description="The archetype catalog name to be used", required=true) String name, @Option(value="url", label="Archetype catalog URL", description="The archetype catalog URL to be used", required=true) URLResource url) {
        this.configuration.setProperty(name, (Object)url.getFullyQualifiedName());
        this.archetypeRegistry.addArchetypeCatalogFactory(name, (URL)url.getUnderlyingResourceObject());
    }

    @Command(value="Archetype: Remove", categories={"Maven"}, help="Removes an archetype catalog from the Forge configuration file")
    public void removeArchetype(@Option(value="named", label="Archetype catalog name", description="The archetype catalog name to be used", required=true) String name) {
        this.configuration.clearProperty(name);
        this.archetypeRegistry.removeArchetypeCatalogFactory(name);
    }

    @Command(value="Archetype: List", categories={"Maven"}, enabled={NonGUIEnabledPredicate.class}, help="Lists the registered archetype catalogs from the Forge configuration file")
    public void listArchetypes(@Option(value="named", label="Archetype catalog name", description="The archetype catalog name to be used") String name, UIOutput output) {
        block3: {
            ArchetypeCatalog archetypeCatalog;
            PrintStream out;
            block2: {
                out = output.out();
                if (!Strings.isNullOrEmpty((String)name)) break block2;
                for (ArchetypeCatalogFactory factory : this.archetypeRegistry.getArchetypeCatalogFactories()) {
                    String key = factory.getName();
                    String catalog = factory.toString();
                    out.println(key + " = " + catalog);
                }
                break block3;
            }
            ArchetypeCatalogFactory archetypeCatalogFactory = this.archetypeRegistry.getArchetypeCatalogFactory(name);
            if (archetypeCatalogFactory == null || (archetypeCatalog = archetypeCatalogFactory.getArchetypeCatalog()) == null) break block3;
            for (Archetype archetype : archetypeCatalog.getArchetypes()) {
                out.println(archetype);
            }
        }
    }
}

