/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.analyzers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.jboss.tattletale.analyzers.AbstractScanner;
import org.jboss.tattletale.analyzers.Extractor;
import org.jboss.tattletale.analyzers.JarScanner;
import org.jboss.tattletale.analyzers.WarScanner;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.core.EarArchive;
import org.jboss.tattletale.core.Location;
import org.jboss.tattletale.profiles.Profile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EarScanner
extends AbstractScanner {
    @Override
    public Archive scan(File file) throws IOException {
        return this.scan(file, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Archive scan(File ear, Map<String, SortedSet<String>> gProvides, List<Profile> known, Set<String> blacklisted) throws IOException {
        if (ear == null || !ear.exists()) {
            return null;
        }
        EarArchive earArchive = null;
        ArrayList<Archive> subArchiveList = new ArrayList<Archive>();
        JarScanner jarScanner = new JarScanner();
        WarScanner warScanner = new WarScanner();
        ZipFile earFile = null;
        String name = ear.getName();
        try {
            JarEntry earEntry;
            String canonicalPath = ear.getCanonicalPath();
            earFile = new JarFile(ear);
            File extractedDir = ear.isFile() ? Extractor.extract((JarFile)earFile) : ear;
            Integer classVersion = null;
            TreeSet<String> requires = new TreeSet<String>();
            TreeMap<String, Long> provides = new TreeMap<String, Long>();
            TreeSet<String> profiles = new TreeSet<String>();
            TreeMap<String, SortedSet<String>> classDependencies = new TreeMap<String, SortedSet<String>>();
            TreeMap<String, SortedSet<String>> packageDependencies = new TreeMap<String, SortedSet<String>>();
            TreeMap<String, SortedSet<String>> blacklistedDependencies = new TreeMap<String, SortedSet<String>>();
            ArrayList<String> lSign = null;
            Enumeration<JarEntry> earEntries = ((JarFile)earFile).entries();
            while (earEntries.hasMoreElements()) {
                File warFile;
                Archive warArchive;
                earEntry = earEntries.nextElement();
                String entryName = earEntry.getName();
                InputStream entryStream = null;
                if (entryName.endsWith(".class")) {
                    try {
                        entryStream = ((JarFile)earFile).getInputStream(earEntry);
                        classVersion = this.scanClasses(entryStream, blacklisted, known, classVersion, provides, requires, profiles, classDependencies, packageDependencies, blacklistedDependencies);
                        continue;
                    }
                    catch (Exception openException) {
                        openException.printStackTrace();
                        continue;
                    }
                    finally {
                        if (entryStream != null) {
                            entryStream.close();
                        }
                        continue;
                    }
                }
                if (entryName.contains("META-INF") && entryName.endsWith(".SF")) {
                    InputStream is = null;
                    try {
                        is = ((JarFile)earFile).getInputStream(earEntry);
                        InputStreamReader isr = new InputStreamReader(is);
                        LineNumberReader lnr = new LineNumberReader(isr);
                        if (lSign == null) {
                            lSign = new ArrayList<String>();
                        }
                        String s = lnr.readLine();
                        while (s != null) {
                            lSign.add(s);
                            s = lnr.readLine();
                        }
                    }
                    catch (Exception ie) {}
                    continue;
                    finally {
                        try {
                            if (is == null) continue;
                            is.close();
                        }
                        catch (IOException ioe) {}
                        continue;
                    }
                }
                if (entryName.endsWith(".jar")) {
                    File jarFile = new File(extractedDir.getCanonicalPath(), entryName);
                    Archive jarArchive = jarScanner.scan(jarFile, gProvides, known, blacklisted);
                    if (jarArchive == null) continue;
                    subArchiveList.add(jarArchive);
                    continue;
                }
                if (!entryName.endsWith(".war") || (warArchive = warScanner.scan(warFile = new File(extractedDir.getCanonicalPath(), entryName), gProvides, known, blacklisted)) == null) continue;
                subArchiveList.add(warArchive);
            }
            if (provides.size() == 0 && subArchiveList.size() == 0) {
                earEntry = null;
                return earEntry;
            }
            String version = null;
            List<String> lManifest = null;
            Manifest manifest = ((JarFile)earFile).getManifest();
            if (manifest != null) {
                version = super.versionFromManifest(manifest);
                lManifest = super.readManifest(manifest);
            }
            Location location = new Location(canonicalPath, version);
            if (subArchiveList.size() > 0 && classVersion == null) {
                classVersion = ((Archive)subArchiveList.get(0)).getVersion();
            }
            if (classVersion == null) {
                classVersion = 0;
            }
            earArchive = new EarArchive(name, classVersion, lManifest, lSign, requires, provides, classDependencies, packageDependencies, blacklistedDependencies, location, subArchiveList);
            super.addProfilesToArchive(earArchive, profiles);
            for (String provide : provides.keySet()) {
                if (gProvides != null) {
                    SortedSet<String> ss = gProvides.get(provide);
                    if (ss == null) {
                        ss = new TreeSet<String>();
                    }
                    ss.add(earArchive.getName());
                    gProvides.put(provide, ss);
                }
                requires.remove(provide);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("Scan: " + e.getMessage());
            e.printStackTrace(System.err);
        }
        finally {
            try {
                if (earFile != null) {
                    earFile.close();
                }
            }
            catch (IOException closeException) {}
        }
        return earArchive;
    }
}

