/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.sync;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.sync.ChangeReader;
import com.sleepycat.je.sync.ExportConfig;
import com.sleepycat.je.sync.ImportConfig;
import com.sleepycat.je.sync.ProcessorMetadata;
import com.sleepycat.je.sync.SyncCanceledException;
import com.sleepycat.je.sync.SyncDataSet;
import com.sleepycat.je.sync.SyncDatabase;
import com.sleepycat.je.sync.impl.LogChangeReader;
import com.sleepycat.je.sync.impl.LogChangeSet;
import com.sleepycat.je.sync.impl.SyncCleanerBarrier;
import com.sleepycat.je.sync.impl.SyncDB;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SyncProcessor {
    protected final Environment env;
    protected final EnvironmentImpl envImpl;
    protected final String processorName;
    private final SyncDB syncDb;
    private TestHook addHook;
    private TestHook removeHook;

    protected SyncProcessor(Environment env, String processorName) {
        this.env = env;
        this.processorName = processorName;
        this.envImpl = DbInternal.getEnvironmentImpl(env);
        this.syncDb = new SyncDB(this.envImpl, true);
    }

    public String getName() {
        return this.processorName;
    }

    public Environment getEnvironment() {
        return this.env;
    }

    public abstract SyncDataSet addDataSet(String var1, Collection<SyncDatabase> var2);

    public void setAddHook(TestHook addHook) {
        this.addHook = addHook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerDataSet(SyncDataSet dataSet) {
        SyncCleanerBarrier syncCleanerBarrier = this.envImpl.getSyncCleanerBarrier();
        synchronized (syncCleanerBarrier) {
            if (this.envImpl.isMaster() && this.envImpl.getSyncCleanerBarrier().isFirstSyncDataSet()) {
                this.envImpl.freezeLocalCBVLSN();
            }
            long endOfLog = this.envImpl.getEndOfLog();
            TestHookExecute.doHookIfSet(this.addHook);
            LogChangeSet.LogChangeSetBinding binding = new LogChangeSet.LogChangeSetBinding();
            DatabaseEntry data = new DatabaseEntry();
            binding.objectToEntry(new LogChangeSet(endOfLog, endOfLog), data);
            this.syncDb.writeChangeSetData(this.env, null, this.processorName, dataSet.getName(), data, SyncDB.OpType.INSERT);
        }
    }

    public abstract void removeDataSet(String var1);

    public void setRemoveHook(TestHook removeHook) {
        this.removeHook = removeHook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterDataSet(String dataSetName) {
        SyncCleanerBarrier syncCleanerBarrier = this.envImpl.getSyncCleanerBarrier();
        synchronized (syncCleanerBarrier) {
            TestHookExecute.doHookIfSet(this.removeHook);
            this.syncDb.writeChangeSetData(this.env, null, this.processorName, dataSetName, null, SyncDB.OpType.DELETE);
        }
    }

    public abstract Map<String, SyncDataSet> getDataSets();

    public abstract void syncAll(ExportConfig var1, ImportConfig var2) throws SyncCanceledException;

    public abstract void sync(ExportConfig var1, ImportConfig var2, String ... var3) throws SyncCanceledException;

    public abstract void cancelSync();

    protected ChangeReader openChangeReader(String dataSetName, boolean consolidateTransactions, long consolidateMaxMemory) {
        return new LogChangeReader(this.env, dataSetName, this, consolidateTransactions, consolidateMaxMemory);
    }

    public final void writeChangeSetData(Transaction txn, String dataSetName, DatabaseEntry data) {
        this.syncDb.writeChangeSetData(this.env, txn, this.processorName, dataSetName, data, SyncDB.OpType.UPDATE);
    }

    public final void readChangeSetData(Transaction txn, String dataSetName, DatabaseEntry data) {
        this.syncDb.readChangeSetData(this.env, txn, this.processorName, dataSetName, data);
    }

    public final <M extends ProcessorMetadata> void writeProcessorMetadata(Transaction txn, M metadata) {
        this.syncDb.writeProcessorMetadata(this.env, txn, this.processorName, metadata);
    }

    public final <M extends ProcessorMetadata> M readProcessorMetadata(Transaction txn) {
        return (M)this.syncDb.readProcessorMetadata(this.env, txn, this);
    }

    protected final void writeProcessorTxnData(Transaction txn, String dataSetName, DatabaseEntry data) {
        this.syncDb.writeProcessorTxnData(this.env, txn, this.processorName, dataSetName, data);
    }

    protected final void readProcessorTxnData(Transaction txn, String dataSetName, DatabaseEntry data) {
        this.syncDb.readProcessorTxnData(this.env, txn, this.processorName, dataSetName, data);
    }

    public SyncDB getSyncDB() {
        return this.syncDb;
    }
}

