/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.model;

import com.sleepycat.asm.ClassReader;
import com.sleepycat.asm.ClassVisitor;
import com.sleepycat.asm.ClassWriter;
import com.sleepycat.persist.model.BytecodeEnhancer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassEnhancer
implements ClassFileTransformer {
    private static final String AGENT_PREFIX = "enhance:";
    private Set<String> packagePrefixes;
    private boolean verbose;

    public static void main(String[] args) throws Exception {
        try {
            boolean verbose = false;
            ArrayList<File> fileList = new ArrayList<File>();
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg.startsWith("-")) {
                    if ("-v".equals(args[i])) {
                        verbose = true;
                        continue;
                    }
                    throw new IllegalArgumentException("Unknown arg: " + arg);
                }
                fileList.add(new File(arg));
            }
            ClassEnhancer enhancer = new ClassEnhancer();
            enhancer.setVerbose(verbose);
            int nFiles = 0;
            for (File file : fileList) {
                nFiles += enhancer.enhanceFile(file);
            }
            if (nFiles > 0) {
                System.out.println("Enhanced: " + nFiles + " files");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void premain(String args, Instrumentation inst) {
        if (!args.startsWith(AGENT_PREFIX)) {
            throw new IllegalArgumentException("Unknown javaagent args: " + args + " Args must start with: \"" + AGENT_PREFIX + '\"');
        }
        args = args.substring(AGENT_PREFIX.length());
        HashSet<String> packageNames = null;
        boolean verbose = false;
        if (args.length() > 0) {
            packageNames = new HashSet<String>();
            StringTokenizer tokens = new StringTokenizer(args, ",");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if (token.startsWith("-")) {
                    if (token.equals("-v")) {
                        verbose = true;
                        continue;
                    }
                    throw new IllegalArgumentException("Unknown javaagent arg: " + token);
                }
                packageNames.add(token);
            }
        }
        ClassEnhancer enhancer = new ClassEnhancer(packageNames);
        enhancer.setVerbose(verbose);
        inst.addTransformer(enhancer);
    }

    public ClassEnhancer() {
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public ClassEnhancer(Set<String> packageNames) {
        if (packageNames != null) {
            this.packagePrefixes = new HashSet<String>();
            for (String name : packageNames) {
                this.packagePrefixes.add(name + '.');
            }
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        className = className.replace('/', '.');
        byte[] bytes = this.enhance(className, classfileBuffer);
        if (this.verbose && bytes != null) {
            System.out.println("Enhanced: " + className);
        }
        return bytes;
    }

    public byte[] enhance(String className, byte[] classBytes) {
        if (className != null && this.packagePrefixes != null) {
            for (String prefix : this.packagePrefixes) {
                if (!className.startsWith(prefix)) continue;
                return this.enhanceBytes(classBytes);
            }
            return null;
        }
        return this.enhanceBytes(classBytes);
    }

    int enhanceFile(File file) throws IOException {
        byte[] newBytes;
        int nFiles = 0;
        if (file.isDirectory()) {
            String[] names = file.list();
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    nFiles += this.enhanceFile(new File(file, names[i]));
                }
            }
        } else if (file.getName().endsWith(".class") && (newBytes = this.enhanceBytes(this.readFile(file))) != null) {
            long modified = file.lastModified();
            this.writeFile(file, newBytes);
            file.setLastModified(modified);
            ++nFiles;
            if (this.verbose) {
                System.out.println("Enhanced: " + file);
            }
        }
        return nFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFile(File file) throws IOException {
        byte[] bytes = new byte[(int)file.length()];
        FileInputStream in = new FileInputStream(file);
        try {
            in.read(bytes);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            in.close();
            throw throwable;
        }
        in.close();
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(File file, byte[] bytes) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            out.write(bytes);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            out.close();
            throw throwable;
        }
        out.close();
    }

    private byte[] enhanceBytes(byte[] bytes) {
        ClassWriter writer;
        ClassVisitor visitor = writer = new ClassWriter(2);
        visitor = new BytecodeEnhancer(visitor);
        ClassReader reader = new ClassReader(bytes);
        try {
            reader.accept(visitor, 0);
            return writer.toByteArray();
        }
        catch (BytecodeEnhancer.NotPersistentException e) {
            return null;
        }
    }
}

