/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.project.condition;

import java.util.ArrayList;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.condition.GraphCondition;
import org.jboss.windup.graph.model.ProjectDependencyModel;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.project.condition.Artifact;
import org.jboss.windup.project.condition.ProjectFrom;
import org.jboss.windup.rules.apps.java.model.project.MavenProjectModel;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class Project
extends GraphCondition {
    private Artifact artifact;

    public static Project dependsOnArtifact(Artifact artifact) {
        Project project = new Project();
        project.artifact = artifact;
        return project;
    }

    public static ProjectFrom from(String from) {
        return new ProjectFrom(from);
    }

    public void setArtifact(Artifact artifact) {
        this.artifact = artifact;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public boolean evaluate(GraphRewrite event, EvaluationContext context) {
        GraphService projectService = new GraphService(event.getGraphContext(), ProjectModel.class);
        Iterable findAll = projectService.findAll();
        ArrayList<ProjectModel> result = new ArrayList<ProjectModel>();
        for (ProjectModel payload : findAll) {
            Iterable dependencies = payload.getDependencies();
            boolean passed = false;
            for (ProjectDependencyModel dependency : dependencies) {
                ProjectModel projectModel = dependency.getProjectModel();
                if (!(projectModel instanceof MavenProjectModel)) continue;
                passed = true;
                MavenProjectModel maven = (MavenProjectModel)projectModel;
                if (this.artifact.getGroupId() != null) {
                    boolean bl = passed = passed && this.artifact.getGroupId().equals(maven.getGroupId());
                }
                if (this.artifact.getArtifactId() != null) {
                    boolean bl = passed = passed && this.artifact.getArtifactId().equals(maven.getArtifactId());
                }
                if (passed && this.artifact.getVersion() != null) {
                    boolean bl = passed = passed && this.artifact.getVersion().validate(maven.getVersion());
                }
                if (!passed) continue;
                break;
            }
            if (!passed) continue;
            result.add(payload);
        }
        if (result.isEmpty()) {
            return false;
        }
        this.setResults(event, this.getOutputVariablesName(), result);
        return true;
    }

    public ConditionBuilder as(String as) {
        super.setOutputVariablesName(as);
        return this;
    }

    public String toString() {
        return "Project.dependsOnArtifact(" + this.artifact.toString() + ")";
    }
}

