/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.connector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import org.xadisk.bridge.proxies.impl.RemoteXAFileSystem;
import org.xadisk.connector.inbound.EndPointActivation;
import org.xadisk.connector.inbound.XADiskActivationSpecImpl;
import org.xadisk.filesystem.FileSystemConfiguration;
import org.xadisk.filesystem.NativeXAFileSystem;
import org.xadisk.filesystem.XAFileSystemCommonness;
import org.xadisk.filesystem.exceptions.XASystemException;

public class XADiskResourceAdapter
extends FileSystemConfiguration
implements ResourceAdapter {
    private static final long serialVersionUID = 1L;
    private transient NativeXAFileSystem xaFileSystem;

    public void start(BootstrapContext bsContext) throws ResourceAdapterInternalException {
        try {
            this.xaFileSystem = NativeXAFileSystem.bootXAFileSystem(this, bsContext.getWorkManager());
        }
        catch (XASystemException xase) {
            throw new ResourceAdapterInternalException((Throwable)xase);
        }
    }

    public void stop() {
        try {
            this.xaFileSystem.shutdown();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void endpointActivation(MessageEndpointFactory mef, ActivationSpec as) throws ResourceException {
        try {
            XADiskActivationSpecImpl xadiskAS = (XADiskActivationSpecImpl)as;
            EndPointActivation epActivation = new EndPointActivation(mef, xadiskAS);
            if (Boolean.valueOf(xadiskAS.getAreFilesRemote()).booleanValue()) {
                String serverAddress = xadiskAS.getRemoteServerAddress();
                Integer serverPort = Integer.valueOf(xadiskAS.getRemoteServerPort());
                RemoteXAFileSystem remoteXAFS = new RemoteXAFileSystem(serverAddress, serverPort, this.xaFileSystem);
                remoteXAFS.registerEndPointActivation(epActivation);
                remoteXAFS.shutdown();
            } else {
                this.xaFileSystem.registerEndPointActivation(epActivation);
            }
        }
        catch (IOException ioe) {
            throw new ResourceException((Throwable)ioe);
        }
    }

    public void endpointDeactivation(MessageEndpointFactory mef, ActivationSpec as) {
        try {
            XADiskActivationSpecImpl xadiskAS = (XADiskActivationSpecImpl)as;
            EndPointActivation epActivation = new EndPointActivation(mef, xadiskAS);
            if (Boolean.valueOf(xadiskAS.getAreFilesRemote()).booleanValue()) {
                String serverAddress = xadiskAS.getRemoteServerAddress();
                Integer serverPort = Integer.valueOf(xadiskAS.getRemoteServerPort());
                RemoteXAFileSystem remoteXAFS = new RemoteXAFileSystem(serverAddress, serverPort, this.xaFileSystem);
                remoteXAFS.deRegisterEndPointActivation(epActivation);
                remoteXAFS.shutdown();
            } else {
                this.xaFileSystem.deRegisterEndPointActivation(epActivation);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public XAResource[] getXAResources(ActivationSpec[] as) throws ResourceException {
        ArrayList<XAResource> xars = new ArrayList<XAResource>();
        HashSet<String> uniqueXADiskInstances = new HashSet<String>();
        for (int i = 0; i < as.length; ++i) {
            XADiskActivationSpecImpl xadiskAS = (XADiskActivationSpecImpl)as[i];
            if (Boolean.valueOf(xadiskAS.getAreFilesRemote()).booleanValue()) {
                String serverAddress = xadiskAS.getRemoteServerAddress();
                Integer serverPort = Integer.valueOf(xadiskAS.getRemoteServerPort());
                uniqueXADiskInstances.add(serverAddress + ":" + serverPort);
                continue;
            }
            uniqueXADiskInstances.add("_");
        }
        for (String xadiskLocations : uniqueXADiskInstances) {
            String[] location = xadiskLocations.split(":");
            XAFileSystemCommonness uniqueXAFileSystem = location.length == 2 ? new RemoteXAFileSystem(location[0], Integer.valueOf(location[1]), this.xaFileSystem) : this.xaFileSystem;
            xars.add(uniqueXAFileSystem.getEventProcessingXAResourceForRecovery());
        }
        return xars.toArray(new XAResource[0]);
    }
}

