/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.acl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.jboss.security.acl.ACL;
import org.jboss.security.acl.ACLEntry;
import org.jboss.security.acl.ACLEntryImpl;
import org.jboss.security.acl.ACLPermission;
import org.jboss.security.acl.Util;
import org.jboss.security.authorization.Resource;
import org.jboss.security.identity.Identity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="ACL")
public class ACLImpl
implements ACL,
Serializable {
    private static final long serialVersionUID = -6390609071167528812L;
    @Id
    @GeneratedValue
    private long aclID;
    @Transient
    private Resource resource;
    @Column(name="resource")
    private String resourceAsString;
    @Transient
    private Map<String, ACLEntry> entriesMap;
    @OneToMany(mappedBy="acl", fetch=FetchType.EAGER, cascade={CascadeType.REMOVE, CascadeType.PERSIST})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    private Collection<ACLEntryImpl> entries;

    ACLImpl() {
    }

    public ACLImpl(Resource resource) {
        this(resource, new ArrayList<ACLEntry>());
    }

    public ACLImpl(Resource resource, Collection<ACLEntry> entries) {
        this(Util.getResourceAsString(resource), entries);
        this.resource = resource;
    }

    public ACLImpl(String resourceString, Collection<ACLEntry> entries) {
        this.resourceAsString = resourceString;
        this.entries = new ArrayList<ACLEntryImpl>();
        if (entries != null) {
            for (ACLEntry entry : entries) {
                ACLEntryImpl entryImpl = (ACLEntryImpl)entry;
                entryImpl.setAcl(this);
                this.entries.add(entryImpl);
            }
        }
        this.initEntriesMap();
    }

    public long getACLId() {
        return this.aclID;
    }

    @Override
    public boolean addEntry(ACLEntry entry) {
        if (this.entriesMap == null) {
            this.initEntriesMap();
        }
        if (entry == null || this.entriesMap.get(entry.getIdentityOrRole()) != null) {
            return false;
        }
        this.entries.add((ACLEntryImpl)entry);
        ((ACLEntryImpl)entry).setAcl(this);
        this.entriesMap.put(entry.getIdentityOrRole(), entry);
        return true;
    }

    @Override
    public boolean removeEntry(ACLEntry entry) {
        if (this.entriesMap == null) {
            this.initEntriesMap();
        }
        this.entriesMap.remove(entry.getIdentityOrRole());
        return this.entries.remove(entry);
    }

    @Override
    public Collection<? extends ACLEntry> getEntries() {
        if (this.entriesMap == null) {
            this.initEntriesMap();
        }
        return Collections.unmodifiableCollection(this.entries);
    }

    @Override
    public ACLEntry getEntry(Identity identity) {
        if (this.entriesMap == null) {
            this.initEntriesMap();
        }
        return this.entriesMap.get(identity.getName());
    }

    @Override
    public ACLEntry getEntry(String identityOrRole) {
        if (this.entriesMap == null) {
            this.initEntriesMap();
        }
        return this.entriesMap.get(identityOrRole);
    }

    @Override
    public boolean isGranted(ACLPermission permission, Identity identity) {
        ACLEntry entry;
        if (this.entriesMap == null) {
            this.initEntriesMap();
        }
        if ((entry = this.entriesMap.get(identity.getName())) != null) {
            return entry.checkPermission(permission);
        }
        return false;
    }

    public String getResourceAsString() {
        return this.resourceAsString;
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        if (this.resource != null) {
            throw new IllegalStateException("PB00019: Processing Failed:ACL resource has already been set");
        }
        this.resource = resource;
    }

    private void initEntriesMap() {
        this.entriesMap = new HashMap<String, ACLEntry>();
        for (ACLEntryImpl entry : this.entries) {
            this.entriesMap.put(entry.getIdentityOrRole(), entry);
        }
    }
}

