/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.login;

import java.util.ArrayList;
import java.util.HashMap;
import javax.security.auth.login.AppConfigurationEntry;
import org.jboss.security.auth.login.AuthenticationInfo;
import org.jboss.security.util.xml.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ConfigUtil {
    public static AuthenticationInfo parseAuthentication(Element policy) throws Exception {
        NodeList authentication = policy.getElementsByTagName("authentication");
        if (authentication.getLength() == 0) {
            return null;
        }
        Element auth = (Element)authentication.item(0);
        NodeList modules = auth.getElementsByTagName("login-module");
        ArrayList tmp = new ArrayList();
        for (int n = 0; n < modules.getLength(); ++n) {
            Element module = (Element)modules.item(n);
            ConfigUtil.parseModule(module, tmp);
        }
        AppConfigurationEntry[] entries = new AppConfigurationEntry[tmp.size()];
        tmp.toArray(entries);
        AuthenticationInfo info = new AuthenticationInfo();
        info.setAppConfigurationEntry(entries);
        return info;
    }

    static void parseModule(Element module, ArrayList entries) throws Exception {
        AppConfigurationEntry.LoginModuleControlFlag controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        String className = DOMUtils.getAttributeValue(module, "code");
        String flag = DOMUtils.getAttributeValue(module, "flag");
        if (flag != null) {
            flag = flag.toLowerCase();
            if (AppConfigurationEntry.LoginModuleControlFlag.REQUIRED.toString().indexOf(flag) > 0) {
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
            } else if (AppConfigurationEntry.LoginModuleControlFlag.REQUISITE.toString().indexOf(flag) > 0) {
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
            } else if (AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT.toString().indexOf(flag) > 0) {
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
            } else if (AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL.toString().indexOf(flag) > 0) {
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
            }
        }
        NodeList opts = module.getElementsByTagName("module-option");
        HashMap<String, String> options = new HashMap<String, String>();
        for (int n = 0; n < opts.getLength(); ++n) {
            Element opt = (Element)opts.item(n);
            String name = opt.getAttribute("name");
            String value = DOMUtils.getTextContent(opt);
            if (value == null) {
                value = "";
            }
            options.put(name, value);
        }
        AppConfigurationEntry entry = new AppConfigurationEntry(className, controlFlag, options);
        entries.add(entry);
    }
}

