/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.factories;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;

class SecurityActions {
    SecurityActions() {
    }

    static ClassLoader getContextClassLoader() throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

            @Override
            public ClassLoader run() throws Exception {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static String getSystemProperty(final String key, final String defaultValue) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key, defaultValue);
            }
        });
    }

    static void setSystemProperty(final String key, final String value) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                System.setProperty(key, value);
                return null;
            }
        });
    }

    static void setSecurityContext(final SecurityContext sc) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SecurityContextAssociation.setSecurityContext(sc);
                return null;
            }
        });
    }
}

