/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ds;

import java.util.Map;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.common.CommonValidationImpl;
import org.jboss.logging.Messages;

public class ValidationImpl
extends CommonValidationImpl
implements Validation {
    private static final long serialVersionUID = 7816717816552118419L;
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);
    private final Extension validConnectionChecker;
    private final String checkValidConnectionSql;
    private final Boolean validateOnMatch;
    private final Extension staleConnectionChecker;
    private final Extension exceptionSorter;

    public ValidationImpl(Boolean backgroundValidation, Long backgroundValidationMillis, Boolean useFastFail, Extension validConnectionChecker, String checkValidConnectionSql, Boolean validateOnMatch, Extension staleConnectionChecker, Extension exceptionSorter) throws ValidateException {
        super(backgroundValidation, backgroundValidationMillis, useFastFail);
        this.validConnectionChecker = validConnectionChecker;
        this.checkValidConnectionSql = checkValidConnectionSql;
        this.validateOnMatch = validateOnMatch;
        this.staleConnectionChecker = staleConnectionChecker;
        this.exceptionSorter = exceptionSorter;
        this.validate();
    }

    public final String getCheckValidConnectionSql() {
        return this.checkValidConnectionSql;
    }

    public final Boolean isValidateOnMatch() {
        return this.validateOnMatch;
    }

    public final Extension getValidConnectionChecker() {
        return this.validConnectionChecker;
    }

    public final Boolean getValidateOnMatch() {
        return this.validateOnMatch;
    }

    public final Extension getStaleConnectionChecker() {
        return this.staleConnectionChecker;
    }

    public final Extension getExceptionSorter() {
        return this.exceptionSorter;
    }

    public void validate() throws ValidateException {
        if (this.backgroundValidationMillis != null && this.backgroundValidationMillis < 0L) {
            throw new ValidateException(bundle.invalidNegative(Validation.Tag.BACKGROUND_VALIDATION_MILLIS.getLocalName()));
        }
        if (this.validConnectionChecker != null) {
            try {
                this.validConnectionChecker.validate();
            }
            catch (ValidateException ve) {
                throw new ValidateException(bundle.invalidTag(Validation.Tag.VALID_CONNECTION_CHECKER.getLocalName()), (Throwable)ve);
            }
        }
        if (this.exceptionSorter != null) {
            try {
                this.exceptionSorter.validate();
            }
            catch (ValidateException ve) {
                throw new ValidateException(bundle.invalidTag(Validation.Tag.EXCEPTION_SORTER.getLocalName()), (Throwable)ve);
            }
        }
        if (this.staleConnectionChecker != null) {
            try {
                this.staleConnectionChecker.validate();
            }
            catch (ValidateException ve) {
                throw new ValidateException(bundle.invalidTag(Validation.Tag.STALE_CONNECTION_CHECKER.getLocalName()), (Throwable)ve);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<validation>");
        if (this.validConnectionChecker != null) {
            sb.append("<").append(Validation.Tag.VALID_CONNECTION_CHECKER);
            sb.append(" ").append(Extension.Attribute.CLASS_NAME).append("=\"");
            sb.append(this.validConnectionChecker.getClassName()).append("\"");
            sb.append(">");
            if (this.validConnectionChecker.getConfigPropertiesMap() != null && this.validConnectionChecker.getConfigPropertiesMap().size() > 0) {
                for (Map.Entry entry : this.validConnectionChecker.getConfigPropertiesMap().entrySet()) {
                    sb.append("<").append(Extension.Tag.CONFIG_PROPERTY);
                    sb.append(" name=\"").append((String)entry.getKey()).append("\">");
                    sb.append((String)entry.getValue());
                    sb.append("</").append(Extension.Tag.CONFIG_PROPERTY).append(">");
                }
            }
            sb.append("</").append(Validation.Tag.VALID_CONNECTION_CHECKER).append(">");
        }
        if (this.checkValidConnectionSql != null) {
            sb.append("<").append(Validation.Tag.CHECK_VALID_CONNECTION_SQL).append(">");
            sb.append(this.checkValidConnectionSql);
            sb.append("</").append(Validation.Tag.CHECK_VALID_CONNECTION_SQL).append(">");
        }
        if (this.validateOnMatch != null) {
            sb.append("<").append(Validation.Tag.VALIDATE_ON_MATCH).append(">");
            sb.append(this.validateOnMatch);
            sb.append("</").append(Validation.Tag.VALIDATE_ON_MATCH).append(">");
        }
        if (this.backgroundValidation != null) {
            sb.append("<").append(Validation.Tag.BACKGROUND_VALIDATION).append(">");
            sb.append(this.backgroundValidation);
            sb.append("</").append(Validation.Tag.BACKGROUND_VALIDATION).append(">");
        }
        if (this.backgroundValidationMillis != null) {
            sb.append("<").append(Validation.Tag.BACKGROUND_VALIDATION_MILLIS).append(">");
            sb.append(this.backgroundValidationMillis);
            sb.append("</").append(Validation.Tag.BACKGROUND_VALIDATION_MILLIS).append(">");
        }
        if (this.useFastFail != null) {
            sb.append("<").append(Validation.Tag.USE_FAST_FAIL).append(">");
            sb.append(this.useFastFail);
            sb.append("</").append(Validation.Tag.USE_FAST_FAIL).append(">");
        }
        if (this.staleConnectionChecker != null) {
            sb.append("<").append(Validation.Tag.STALE_CONNECTION_CHECKER);
            sb.append(" ").append(Extension.Attribute.CLASS_NAME).append("=\"");
            sb.append(this.staleConnectionChecker.getClassName()).append("\"");
            sb.append(">");
            if (this.staleConnectionChecker.getConfigPropertiesMap() != null && this.staleConnectionChecker.getConfigPropertiesMap().size() > 0) {
                for (Map.Entry entry : this.staleConnectionChecker.getConfigPropertiesMap().entrySet()) {
                    sb.append("<").append(Extension.Tag.CONFIG_PROPERTY);
                    sb.append(" name=\"").append((String)entry.getKey()).append("\">");
                    sb.append((String)entry.getValue());
                    sb.append("</").append(Extension.Tag.CONFIG_PROPERTY).append(">");
                }
            }
            sb.append("</").append(Validation.Tag.STALE_CONNECTION_CHECKER).append(">");
        }
        if (this.exceptionSorter != null) {
            sb.append("<").append(Validation.Tag.EXCEPTION_SORTER);
            sb.append(" ").append(Extension.Attribute.CLASS_NAME).append("=\"");
            sb.append(this.exceptionSorter.getClassName()).append("\"");
            sb.append(">");
            if (this.exceptionSorter.getConfigPropertiesMap() != null && this.exceptionSorter.getConfigPropertiesMap().size() > 0) {
                for (Map.Entry entry : this.exceptionSorter.getConfigPropertiesMap().entrySet()) {
                    sb.append("<").append(Extension.Tag.CONFIG_PROPERTY);
                    sb.append(" name=\"").append((String)entry.getKey()).append("\">");
                    sb.append((String)entry.getValue());
                    sb.append("</").append(Extension.Tag.CONFIG_PROPERTY).append(">");
                }
            }
            sb.append("</").append(Validation.Tag.EXCEPTION_SORTER).append(">");
        }
        sb.append("</validation>");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.checkValidConnectionSql == null ? 0 : this.checkValidConnectionSql.hashCode());
        result = 31 * result + (this.exceptionSorter == null ? 0 : this.exceptionSorter.hashCode());
        result = 31 * result + (this.staleConnectionChecker == null ? 0 : this.staleConnectionChecker.hashCode());
        result = 31 * result + (this.validConnectionChecker == null ? 0 : this.validConnectionChecker.hashCode());
        result = 31 * result + (this.validateOnMatch == null ? 0 : this.validateOnMatch.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ValidationImpl)) {
            return false;
        }
        ValidationImpl other = (ValidationImpl)obj;
        if (this.checkValidConnectionSql == null ? other.checkValidConnectionSql != null : !this.checkValidConnectionSql.equals(other.checkValidConnectionSql)) {
            return false;
        }
        if (this.exceptionSorter == null ? other.exceptionSorter != null : !this.exceptionSorter.equals((Object)other.exceptionSorter)) {
            return false;
        }
        if (this.staleConnectionChecker == null ? other.staleConnectionChecker != null : !this.staleConnectionChecker.equals((Object)other.staleConnectionChecker)) {
            return false;
        }
        if (this.validConnectionChecker == null ? other.validConnectionChecker != null : !this.validConnectionChecker.equals((Object)other.validConnectionChecker)) {
            return false;
        }
        return !(this.validateOnMatch == null ? other.validateOnMatch != null : !this.validateOnMatch.equals(other.validateOnMatch));
    }
}

