/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.function;

import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.function.Function;
import org.openrdf.query.algebra.evaluation.util.QueryEvaluationUtil;

public class DoubleCast
implements Function {
    @Override
    public String getURI() {
        return XMLSchema.DOUBLE.toString();
    }

    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException("xsd:double cast requires exactly 1 argument, got " + args.length);
        }
        if (args[0] instanceof Literal) {
            Literal literal = (Literal)args[0];
            URI datatype = literal.getDatatype();
            if (QueryEvaluationUtil.isStringLiteral(literal)) {
                String doubleValue = XMLDatatypeUtil.collapseWhiteSpace((String)literal.getLabel());
                if (XMLDatatypeUtil.isValidDouble((String)doubleValue)) {
                    return valueFactory.createLiteral(doubleValue, XMLSchema.DOUBLE);
                }
            } else if (datatype != null) {
                if (datatype.equals((Object)XMLSchema.DOUBLE)) {
                    return literal;
                }
                if (XMLDatatypeUtil.isNumericDatatype((URI)datatype)) {
                    try {
                        double doubleValue = literal.doubleValue();
                        return valueFactory.createLiteral(doubleValue);
                    }
                    catch (NumberFormatException e) {
                        throw new ValueExprEvaluationException(e.getMessage(), e);
                    }
                }
                if (datatype.equals((Object)XMLSchema.BOOLEAN)) {
                    try {
                        return valueFactory.createLiteral(literal.booleanValue() ? 1.0 : 0.0);
                    }
                    catch (IllegalArgumentException e) {
                        throw new ValueExprEvaluationException(e.getMessage(), e);
                    }
                }
            }
        }
        throw new ValueExprEvaluationException("Invalid argument for xsd:double cast: " + args[0]);
    }
}

