/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor;

import java.util.HashMap;
import java.util.List;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceUnit;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.FieldInjectionTarget;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.InjectionTarget;
import org.jboss.as.ee.component.LookupInjectionSource;
import org.jboss.as.ee.component.MethodInjectionTarget;
import org.jboss.as.ee.component.ResourceInjectionConfiguration;
import org.jboss.as.jpa.JpaMessages;
import org.jboss.as.jpa.container.PersistenceUnitSearch;
import org.jboss.as.jpa.injectors.PersistenceContextInjectionSource;
import org.jboss.as.jpa.injectors.PersistenceUnitInjectionSource;
import org.jboss.as.jpa.processor.JPADeploymentMarker;
import org.jboss.as.jpa.service.PersistenceUnitServiceImpl;
import org.jboss.as.jpa.spi.PersistenceUnitMetadata;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.msc.service.ServiceName;

public class JPAAnnotationParseProcessor
implements DeploymentUnitProcessor {
    private static final DotName PERSISTENCE_CONTEXT_ANNOTATION_NAME = DotName.createSimple((String)PersistenceContext.class.getName());
    private static final DotName PERSISTENCE_UNIT_ANNOTATION_NAME = DotName.createSimple((String)PersistenceUnit.class.getName());
    private static final String ENTITY_MANAGER_CLASS = "javax.persistence.EntityManager";
    private static final String ENTITY_MANAGERFACTORY_CLASS = "javax.persistence.EntityManagerFactory";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        List persistenceContexts = index.getAnnotations(PERSISTENCE_CONTEXT_ANNOTATION_NAME);
        this.processPersistenceAnnotations(deploymentUnit, eeModuleDescription, persistenceContexts, applicationClasses);
        List persistenceUnits = index.getAnnotations(PERSISTENCE_UNIT_ANNOTATION_NAME);
        this.processPersistenceAnnotations(deploymentUnit, eeModuleDescription, persistenceUnits, applicationClasses);
        if (!persistenceContexts.isEmpty() || !persistenceUnits.isEmpty()) {
            JPADeploymentMarker.mark(deploymentUnit);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void processPersistenceAnnotations(DeploymentUnit deploymentUnit, EEModuleDescription eeModuleDescription, List<AnnotationInstance> persistenceContexts, EEApplicationClasses applicationClasses) throws DeploymentUnitProcessingException {
        for (AnnotationInstance annotation : persistenceContexts) {
            EEModuleClassDescription eeModuleClassDescription;
            ClassInfo declaringClass = null;
            AnnotationTarget annotationTarget = annotation.target();
            if (annotationTarget instanceof FieldInfo) {
                FieldInfo fieldInfo = (FieldInfo)annotationTarget;
                declaringClass = fieldInfo.declaringClass();
                eeModuleClassDescription = eeModuleDescription.addOrGetLocalClassDescription(declaringClass.name().toString());
                this.processField(deploymentUnit, annotation, fieldInfo, eeModuleClassDescription);
                continue;
            }
            if (annotationTarget instanceof MethodInfo) {
                MethodInfo methodInfo = (MethodInfo)annotationTarget;
                declaringClass = methodInfo.declaringClass();
                eeModuleClassDescription = eeModuleDescription.addOrGetLocalClassDescription(declaringClass.name().toString());
                this.processMethod(deploymentUnit, annotation, methodInfo, eeModuleClassDescription);
                continue;
            }
            if (!(annotationTarget instanceof ClassInfo)) continue;
            declaringClass = (ClassInfo)annotationTarget;
            EEModuleClassDescription eeModuleClassDescription2 = eeModuleDescription.addOrGetLocalClassDescription(declaringClass.name().toString());
            this.processClass(deploymentUnit, annotation, eeModuleClassDescription2);
        }
    }

    private void processField(DeploymentUnit deploymentUnit, AnnotationInstance annotation, FieldInfo fieldInfo, EEModuleClassDescription eeModuleClassDescription) throws DeploymentUnitProcessingException {
        String fieldName = fieldInfo.name();
        AnnotationValue declaredNameValue = annotation.value("name");
        String declaredName = declaredNameValue != null ? declaredNameValue.asString() : null;
        String localContextName = declaredName == null || declaredName.isEmpty() ? fieldInfo.declaringClass().name().toString() + "/" + fieldName : declaredName;
        DotName declaredTypeDotName = fieldInfo.type().name();
        DotName injectionTypeDotName = declaredTypeDotName == null || declaredTypeDotName.toString().equals(Object.class.getName()) ? fieldInfo.type().name() : declaredTypeDotName;
        String injectionType = injectionTypeDotName.toString();
        InjectionSource bindingSource = this.getBindingSource(deploymentUnit, annotation, injectionType, eeModuleClassDescription);
        if (bindingSource != null) {
            BindingConfiguration bindingConfiguration = new BindingConfiguration(localContextName, bindingSource);
            eeModuleClassDescription.getBindingConfigurations().add(bindingConfiguration);
            FieldInjectionTarget injectionTarget = new FieldInjectionTarget(fieldInfo.declaringClass().name().toString(), fieldName, fieldInfo.type().name().toString());
            LookupInjectionSource injectionSource = new LookupInjectionSource(localContextName);
            ResourceInjectionConfiguration injectionConfiguration = new ResourceInjectionConfiguration((InjectionTarget)injectionTarget, (InjectionSource)injectionSource);
            eeModuleClassDescription.addResourceInjection(injectionConfiguration);
        }
    }

    private void processMethod(DeploymentUnit deploymentUnit, AnnotationInstance annotation, MethodInfo methodInfo, EEModuleClassDescription eeModuleClassDescription) throws DeploymentUnitProcessingException {
        String methodName = methodInfo.name();
        if (!methodName.startsWith("set") || methodInfo.args().length != 1) {
            eeModuleClassDescription.setInvalid(JpaMessages.MESSAGES.setterMethodOnlyAnnotation(annotation.name().toString(), methodInfo));
            return;
        }
        String contextNameSuffix = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
        AnnotationValue declaredNameValue = annotation.value("name");
        String declaredName = declaredNameValue != null ? declaredNameValue.asString() : null;
        String localContextName = declaredName == null || declaredName.isEmpty() ? methodInfo.declaringClass().name().toString() + "/" + contextNameSuffix : declaredName;
        String injectionType = methodInfo.args()[0].name().toString();
        InjectionSource bindingSource = this.getBindingSource(deploymentUnit, annotation, injectionType, eeModuleClassDescription);
        if (bindingSource != null) {
            BindingConfiguration bindingConfiguration = new BindingConfiguration(localContextName, bindingSource);
            eeModuleClassDescription.getBindingConfigurations().add(bindingConfiguration);
            MethodInjectionTarget injectionTarget = new MethodInjectionTarget(methodInfo.declaringClass().name().toString(), methodName, methodInfo.args()[0].name().toString());
            LookupInjectionSource injectionSource = new LookupInjectionSource(localContextName);
            ResourceInjectionConfiguration injectionConfiguration = new ResourceInjectionConfiguration((InjectionTarget)injectionTarget, (InjectionSource)injectionSource);
            eeModuleClassDescription.addResourceInjection(injectionConfiguration);
        }
    }

    private void processClass(DeploymentUnit deploymentUnit, AnnotationInstance annotation, EEModuleClassDescription eeModuleClassDescription) throws DeploymentUnitProcessingException {
        AnnotationValue nameValue = annotation.value("name");
        if (nameValue == null || nameValue.asString().isEmpty()) {
            throw JpaMessages.MESSAGES.classLevelAnnotationParameterRequired(annotation.name().toString(), "name");
        }
        String name = nameValue.asString();
        String type = this.getClassLevelInjectionType(annotation);
        InjectionSource bindingSource = this.getBindingSource(deploymentUnit, annotation, type, eeModuleClassDescription);
        if (bindingSource != null) {
            BindingConfiguration bindingConfiguration = new BindingConfiguration(name, bindingSource);
            eeModuleClassDescription.getBindingConfigurations().add(bindingConfiguration);
        }
    }

    private InjectionSource getBindingSource(DeploymentUnit deploymentUnit, AnnotationInstance annotation, String injectionTypeName, EEModuleClassDescription classDescription) throws DeploymentUnitProcessingException {
        PersistenceUnitMetadata pu = this.getPersistenceUnit(deploymentUnit, annotation, classDescription);
        if (pu == null) {
            return null;
        }
        String scopedPuName = pu.getScopedPersistenceUnitName();
        ServiceName puServiceName = this.getPuServiceName(scopedPuName);
        if (this.isPersistenceContext(annotation)) {
            HashMap<AnnotationValue, AnnotationValue> properties;
            AnnotationInstance[] props;
            if (pu.getTransactionType() == PersistenceUnitTransactionType.RESOURCE_LOCAL) {
                classDescription.setInvalid(JpaMessages.MESSAGES.cannotInjectResourceLocalEntityManager());
                return null;
            }
            AnnotationValue pcType = annotation.value("type");
            PersistenceContextType type = pcType == null || PersistenceContextType.TRANSACTION.name().equals(pcType.asString()) ? PersistenceContextType.TRANSACTION : PersistenceContextType.EXTENDED;
            AnnotationValue value = annotation.value("properties");
            AnnotationInstance[] annotationInstanceArray = props = value != null ? value.asNestedArray() : null;
            if (props != null) {
                properties = new HashMap<AnnotationValue, AnnotationValue>();
                for (int source = 0; source < props.length; ++source) {
                    properties.put(props[source].value("name"), props[source].value("value"));
                }
            } else {
                properties = null;
            }
            return new PersistenceContextInjectionSource(type, properties, puServiceName, deploymentUnit, scopedPuName, injectionTypeName, pu);
        }
        return new PersistenceUnitInjectionSource(puServiceName, deploymentUnit, injectionTypeName, pu);
    }

    private boolean isExtendedPersistenceContext(AnnotationInstance annotation) {
        AnnotationValue value = annotation.value("type");
        return annotation.name().local().equals("PersistenceContext") && value != null && PersistenceContextType.EXTENDED.name().equals(value.asString());
    }

    private boolean isPersistenceContext(AnnotationInstance annotation) {
        return annotation.name().local().equals("PersistenceContext");
    }

    private String getClassLevelInjectionType(AnnotationInstance annotation) {
        boolean isPC = annotation.name().local().equals("PersistenceContext");
        return isPC ? ENTITY_MANAGER_CLASS : ENTITY_MANAGERFACTORY_CLASS;
    }

    private PersistenceUnitMetadata getPersistenceUnit(DeploymentUnit deploymentUnit, AnnotationInstance annotation, EEModuleClassDescription classDescription) throws DeploymentUnitProcessingException {
        PersistenceUnitMetadata pu;
        AnnotationValue puName = annotation.value("unitName");
        String searchName = null;
        if (puName != null) {
            searchName = puName.asString();
        }
        if (null == (pu = PersistenceUnitSearch.resolvePersistenceUnitSupplier(deploymentUnit, searchName))) {
            classDescription.setInvalid(JpaMessages.MESSAGES.persistenceUnitNotFound(searchName, deploymentUnit));
            return null;
        }
        return pu;
    }

    private ServiceName getPuServiceName(String scopedPuName) throws DeploymentUnitProcessingException {
        return PersistenceUnitServiceImpl.getPUServiceName(scopedPuName);
    }
}

