/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.freemarker;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.jboss.forge.furnace.Furnace;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.Variables;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.reporting.freemarker.FreeMarkerUtil;
import org.jboss.windup.reporting.freemarker.FurnaceFreeMarkerTemplateLoader;
import org.jboss.windup.reporting.service.ReportService;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class FreeMarkerOperation
extends GraphOperation {
    private static final Logger LOG = Logger.getLogger(FreeMarkerOperation.class.getName());
    private Furnace furnace;
    private String templatePath;
    private String outputFilename;
    private List<String> variableNames = new ArrayList<String>();

    protected FreeMarkerOperation(Furnace furnace, String templatePath, String outputFilename, String ... varNames) {
        this.furnace = furnace;
        this.templatePath = templatePath;
        this.outputFilename = outputFilename;
        this.variableNames = Arrays.asList(varNames);
    }

    public static FreeMarkerOperation create(Furnace furnace, String templatePath, String outputFilename, String ... varNames) {
        return new FreeMarkerOperation(furnace, templatePath, outputFilename, varNames);
    }

    public void perform(GraphRewrite event, EvaluationContext context) {
        try {
            ReportService reportService = new ReportService(event.getGraphContext());
            String outputDir = reportService.getReportDirectory();
            Path outputPath = Paths.get(outputDir, this.outputFilename);
            LOG.info("Reporting: Writing template \"" + this.templatePath + "\" to output file \"" + outputPath.toAbsolutePath().toString() + "\"");
            Configuration cfg = new Configuration();
            cfg.setTemplateLoader((TemplateLoader)new FurnaceFreeMarkerTemplateLoader());
            cfg.setTemplateUpdateDelay(500);
            Template template = cfg.getTemplate(this.templatePath);
            Variables varStack = Variables.instance((GraphRewrite)event);
            Map<String, Object> vars = FreeMarkerUtil.findFreeMarkerContextVariables(varStack, this.variableNames.toArray(new String[this.variableNames.size()]));
            Map<String, Object> freeMarkerExtensions = FreeMarkerUtil.findFreeMarkerExtensions(this.furnace, event);
            HashMap<String, Object> objects = new HashMap<String, Object>(vars);
            objects.putAll(freeMarkerExtensions);
            try (FileWriter fw = new FileWriter(outputPath.toFile());){
                template.process(objects, (Writer)fw);
            }
        }
        catch (IOException e) {
            throw new WindupException("Failed to write template results due to: " + e.getMessage(), (Throwable)e);
        }
        catch (TemplateException e) {
            throw new WindupException("FreeMarkerOperation TemplateException: " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        return "FreeMarkerOperation[template=" + this.templatePath + ", output=" + this.outputFilename + "]";
    }
}

