/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.oupls.sail;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.KeyIndexableGraph;
import com.tinkerpop.blueprints.Parameter;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.oupls.sail.GraphBasedMatcher;
import com.tinkerpop.blueprints.oupls.sail.GraphSailConnection;
import com.tinkerpop.blueprints.oupls.sail.IndexingMatcher;
import com.tinkerpop.blueprints.oupls.sail.Matcher;
import com.tinkerpop.blueprints.oupls.sail.TrivialMatcher;
import com.tinkerpop.blueprints.util.wrappers.WrapperGraph;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;
import org.openrdf.sail.NotifyingSailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.NotifyingSailBase;

public class GraphSail<T extends KeyIndexableGraph>
extends NotifyingSailBase
implements WrapperGraph<T> {
    private static final Logger LOGGER = Logger.getLogger(GraphSail.class.getName());
    public static final String SEPARATOR = " ";
    public static final String PREDICATE_PROP = "p";
    public static final String CONTEXT_PROP = "c";
    public static final char URI_PREFIX = 'U';
    public static final char BLANK_NODE_PREFIX = 'B';
    public static final char PLAIN_LITERAL_PREFIX = 'P';
    public static final char TYPED_LITERAL_PREFIX = 'T';
    public static final char LANGUAGE_TAG_LITERAL_PREFIX = 'L';
    public static final char NULL_CONTEXT_PREFIX = 'N';
    public static final Pattern INDEX_PATTERN = Pattern.compile("s?p?o?c?");
    public static final String BNODE = "bnode";
    public static final String INFERRED = "inferred";
    public static final String KIND = "kind";
    public static final String LANG = "lang";
    public static final String LITERAL = "literal";
    public static final String TYPE = "type";
    public static final String URI = "uri";
    public static final String VALUE = "value";
    public static final String DEFAULT_NAMESPACE_PREFIX_KEY = "default-namespace";
    public static final String NULL_CONTEXT_NATIVE = "N";
    private static final String[][] ALTERNATIVES = new String[][]{{"s", ""}, {"p", ""}, {"o", ""}, {"c", ""}, {"sp", "s", "p"}, {"so", "s", "o"}, {"sc", "s", "c"}, {"po", "o", "p"}, {"pc", "p", "c"}, {"oc", "o", "c"}, {"spo", "so", "sp", "po"}, {"spc", "sc", "sp", "pc"}, {"soc", "so", "sc", "oc"}, {"poc", "po", "oc", "pc"}, {"spoc", "spo", "soc", "spc", "poc"}};
    private static final String NAMESPACES_VERTEX_ID = "urn:com.tinkerpop.blueprints.pgm.oupls.sail:namespaces";
    private final DataStore store = new DataStore();

    public GraphSail(T graph) {
        this(graph, "p,c,pc");
        RDFParser p = Rio.createParser((RDFFormat)RDFFormat.NTRIPLES);
        p.setRDFHandler(new RDFHandler(){

            public void startRDF() throws RDFHandlerException {
            }

            public void endRDF() throws RDFHandlerException {
            }

            public void handleNamespace(String s, String s1) throws RDFHandlerException {
            }

            public void handleStatement(Statement s) throws RDFHandlerException {
            }

            public void handleComment(String s) throws RDFHandlerException {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphSail(T graph, String indexedPatterns) {
        this.store.sail = this;
        this.store.graph = graph;
        this.store.manualTransactions = this.store.graph instanceof TransactionalGraph;
        if (!this.store.graph.getIndexedKeys(Vertex.class).contains(VALUE)) {
            this.store.graph.createKeyIndex(VALUE, Vertex.class, new Parameter[0]);
        }
        this.store.matchers[0] = new TrivialMatcher((Graph)graph);
        this.createTripleIndices(indexedPatterns);
        this.assignUnassignedTriplePatterns();
        this.store.namespaces = this.store.getReferenceVertex();
        if (null == this.store.namespaces) {
            try {
                this.store.namespaces = this.store.addVertex(NAMESPACES_VERTEX_ID);
            }
            finally {
                if (this.store.manualTransactions) {
                    ((TransactionalGraph)graph).commit();
                }
            }
        }
    }

    public T getBaseGraph() {
        return this.store.getGraph();
    }

    public void initializeInternal() throws SailException {
    }

    public void shutDownInternal() throws SailException {
        this.store.graph.shutdown();
    }

    public boolean isWritable() throws SailException {
        return true;
    }

    public NotifyingSailConnection getConnectionInternal() throws SailException {
        return new GraphSailConnection(this.store);
    }

    public ValueFactory getValueFactory() {
        return this.store.valueFactory;
    }

    public void useVolatileStatements(boolean flag) {
        this.store.volatileStatements = flag;
    }

    public void enforceUniqueStatements(boolean flag) {
        this.store.uniqueStatements = flag;
    }

    public String toString() {
        String type = this.store.graph.getClass().getSimpleName().toLowerCase();
        return "graphsail[" + type + "]";
    }

    private void createTripleIndices(String tripleIndexes) {
        String[] a;
        if (null == tripleIndexes) {
            throw new IllegalArgumentException("index list, if supplied, must be non-null");
        }
        HashSet<String> u = new HashSet<String>();
        for (String s : a = tripleIndexes.split(",")) {
            String pattern = s.trim();
            if (pattern.length() <= 0) continue;
            u.add(pattern);
        }
        if (!u.contains(PREDICATE_PROP)) {
            LOGGER.warning("no (?s p ?o ?c) index. Certain query operations will be inefficient");
        }
        if (!u.contains(CONTEXT_PROP)) {
            LOGGER.warning("no (?s ?p ?o c) index. Certain query operations will be inefficient");
        }
        for (String key : u) {
            if (!this.store.graph.getIndexedKeys(Edge.class).contains(key)) {
                this.store.graph.createKeyIndex(key, Edge.class, new Parameter[0]);
            }
            this.createIndexingMatcher(key);
        }
    }

    private void assignUnassignedTriplePatterns() {
        for (int i = 0; i < 16; ++i) {
            if (null != this.store.matchers[i] || 0 == (i & 1) && 0 == (i & 4)) continue;
            this.store.matchers[i] = new GraphBasedMatcher(0 != (i & 1), 0 != (i & 2), 0 != (i & 4), 0 != (i & 8), this.store);
        }
        Matcher[] n = new Matcher[16];
        n[0] = this.store.matchers[0];
        for (String[] alts : ALTERNATIVES) {
            String p = alts[0];
            int i = this.indexFor(p);
            Matcher m = this.store.matchers[i];
            if (null == m) {
                for (int j = 1; j < alts.length && null == (m = this.store.matchers[this.indexFor(alts[j])]); ++j) {
                }
                if (null == m) {
                    m = n[1];
                }
            }
            n[i] = m;
        }
        System.arraycopy(n, 0, this.store.matchers, 0, 16);
    }

    private int indexFor(boolean s, boolean p, boolean o, boolean c) {
        int index = 0;
        if (s) {
            index |= 1;
        }
        if (p) {
            index |= 2;
        }
        if (o) {
            index |= 4;
        }
        if (c) {
            index |= 8;
        }
        return index;
    }

    private int indexFor(String pattern) {
        boolean s = false;
        boolean p = false;
        boolean o = false;
        boolean c = false;
        block6: for (byte ch : pattern.getBytes()) {
            switch (ch) {
                case 115: {
                    s = true;
                    continue block6;
                }
                case 112: {
                    p = true;
                    continue block6;
                }
                case 111: {
                    o = true;
                    continue block6;
                }
                case 99: {
                    c = true;
                    continue block6;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return this.indexFor(s, p, o, c);
    }

    private void createIndexingMatcher(String pattern) {
        boolean s = false;
        boolean p = false;
        boolean o = false;
        boolean c = false;
        block6: for (byte ch : pattern.getBytes()) {
            switch (ch) {
                case 115: {
                    s = true;
                    continue block6;
                }
                case 112: {
                    p = true;
                    continue block6;
                }
                case 111: {
                    o = true;
                    continue block6;
                }
                case 99: {
                    c = true;
                    continue block6;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        int index = this.indexFor(s, p, o, c);
        IndexingMatcher m = new IndexingMatcher(s, p, o, c, this.store);
        this.store.matchers[index] = m;
        this.store.indexers.add(m);
    }

    private static void debugEdge(Edge e) {
        System.out.println("edge " + e + ":");
        for (String key : e.getPropertyKeys()) {
            System.out.println("\t" + key + ":\t'" + e.getProperty(key) + "'");
        }
        System.out.println("\t[in vertex]: " + e.getVertex(Direction.IN));
        System.out.println("\t[out vertex]: " + e.getVertex(Direction.OUT));
    }

    private static void debugVertex(Vertex v) {
        System.out.println("vertex " + v + ":");
        for (String key : v.getPropertyKeys()) {
            System.out.println("\t" + key + ":\t'" + v.getProperty(key) + "'");
        }
        Iterator i = v.getEdges(Direction.IN, new String[0]).iterator();
        System.out.println("\t[in edges]:");
        while (i.hasNext()) {
            System.out.println("\t\t" + i.next());
        }
        i = v.getEdges(Direction.OUT, new String[0]).iterator();
        System.out.println("\t[out edges]:");
        while (i.hasNext()) {
            System.out.println("\t\t" + i.next());
        }
    }

    class DataStore {
        public T graph;
        public NotifyingSailBase sail;
        public final ValueFactory valueFactory = new ValueFactoryImpl();
        public final Collection<IndexingMatcher> indexers = new LinkedList<IndexingMatcher>();
        public final Matcher[] matchers = new Matcher[16];
        public boolean manualTransactions;
        public boolean volatileStatements = false;
        public boolean uniqueStatements = false;
        public Vertex namespaces;

        DataStore() {
        }

        public Vertex getReferenceVertex() {
            Iterable i = ((GraphSail)GraphSail.this).store.graph.getVertices(GraphSail.VALUE, (Object)GraphSail.NAMESPACES_VERTEX_ID);
            Iterator iter = i.iterator();
            return iter.hasNext() ? (Vertex)iter.next() : null;
        }

        public Vertex addVertex(Value value) {
            Vertex v = this.graph.addVertex(null);
            if (value instanceof URI) {
                v.setProperty(GraphSail.KIND, (Object)GraphSail.URI);
                v.setProperty(GraphSail.VALUE, (Object)value.stringValue());
            } else if (value instanceof Literal) {
                Literal l = (Literal)value;
                v.setProperty(GraphSail.KIND, (Object)GraphSail.LITERAL);
                v.setProperty(GraphSail.VALUE, (Object)l.getLabel());
                if (null != l.getDatatype()) {
                    v.setProperty(GraphSail.TYPE, (Object)l.getDatatype().stringValue());
                }
                if (null != l.getLanguage()) {
                    v.setProperty(GraphSail.LANG, (Object)l.getLanguage());
                }
            } else if (value instanceof BNode) {
                BNode b = (BNode)value;
                v.setProperty(GraphSail.KIND, (Object)GraphSail.BNODE);
                v.setProperty(GraphSail.VALUE, (Object)b.getID());
            } else {
                throw new IllegalStateException("value of unexpected type: " + value);
            }
            return v;
        }

        public Vertex findVertex(Value value) {
            for (Vertex v : ((GraphSail)GraphSail.this).store.graph.getVertices(GraphSail.VALUE, (Object)value.stringValue())) {
                if (!this.matches(v, value)) continue;
                return v;
            }
            return null;
        }

        public boolean matches(Vertex vertex, Value value) {
            String kind = (String)vertex.getProperty(GraphSail.KIND);
            String val = (String)vertex.getProperty(GraphSail.VALUE);
            if (value instanceof URI) {
                return kind.equals(GraphSail.URI) && val.equals(value.stringValue());
            }
            if (value instanceof Literal) {
                if (kind.equals(GraphSail.LITERAL)) {
                    if (!val.equals(((Literal)value).getLabel())) {
                        return false;
                    }
                    String type = (String)vertex.getProperty(GraphSail.TYPE);
                    String lang = (String)vertex.getProperty(GraphSail.LANG);
                    URI vType = ((Literal)value).getDatatype();
                    String vLang = ((Literal)value).getLanguage();
                    return null == type && null == vType && null == lang && null == vLang || null != type && null != vType && type.equals(vType.stringValue()) || null != lang && null != vLang && lang.equals(vLang);
                }
                return false;
            }
            if (value instanceof BNode) {
                return kind.equals(GraphSail.BNODE) && ((BNode)value).getID().equals(val);
            }
            throw new IllegalStateException("value of unexpected kind: " + value);
        }

        public Vertex addVertex(String id) {
            Vertex v = this.graph.addVertex(null);
            v.setProperty(GraphSail.VALUE, (Object)id);
            return v;
        }

        public String getValueOf(Vertex v) {
            return (String)v.getProperty(GraphSail.VALUE);
        }

        public T getGraph() {
            return this.graph;
        }

        public String valueToNative(Value value) {
            if (null == value) {
                return GraphSail.NULL_CONTEXT_NATIVE;
            }
            if (value instanceof Resource) {
                return this.resourceToNative((Resource)value);
            }
            if (value instanceof Literal) {
                return this.literalToNative((Literal)value);
            }
            throw new IllegalStateException("Value has unfamiliar type: " + value);
        }

        public String resourceToNative(Resource value) {
            if (value instanceof URI) {
                return this.uriToNative((URI)value);
            }
            if (value instanceof BNode) {
                return this.bnodeToNative((BNode)value);
            }
            throw new IllegalStateException("Resource has unfamiliar type: " + value);
        }

        public String uriToNative(URI value) {
            return "U " + value.toString();
        }

        public String bnodeToNative(BNode value) {
            return "B " + value.getID();
        }

        public String literalToNative(Literal literal) {
            URI datatype = literal.getDatatype();
            if (null == datatype) {
                String language = literal.getLanguage();
                if (null == language) {
                    return "P " + literal.getLabel();
                }
                return "L " + language + GraphSail.SEPARATOR + literal.getLabel();
            }
            return "T " + datatype + GraphSail.SEPARATOR + literal.getLabel();
        }
    }
}

