/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.impl;

import java.lang.annotation.Annotation;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import org.jboss.forge.addon.ui.cdi.CommandScoped;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextListener;

public class CommandScopedContext
implements Context,
UIContextListener {
    private static final String COMPONENT_MAP_NAME = CommandScopedContext.class.getName() + ".componentInstanceMap";
    private static final String CREATIONAL_MAP_NAME = CommandScopedContext.class.getName() + ".creationalInstanceMap";
    private static final LinkedList<UIContext> CONTEXT_STACK = new LinkedList();

    public Class<? extends Annotation> getScope() {
        return CommandScoped.class;
    }

    public <T> T get(Contextual<T> component) {
        this.assertActive();
        return (T)this.getComponentInstanceMap().get(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Contextual<T> component, CreationalContext<T> creationalContext) {
        this.assertActive();
        Object instance = this.get(component);
        if (instance == null) {
            Map<Contextual<?>, Object> componentInstanceMap;
            Map<Contextual<?>, CreationalContext<?>> creationalContextMap = this.getCreationalContextMap();
            Map<Contextual<?>, Object> map = componentInstanceMap = this.getComponentInstanceMap();
            synchronized (map) {
                instance = componentInstanceMap.get(component);
                if (instance == null && (instance = component.create(creationalContext)) != null) {
                    componentInstanceMap.put(component, instance);
                    creationalContextMap.put(component, creationalContext);
                }
            }
        }
        return instance;
    }

    private void assertActive() {
        if (!this.isActive()) {
            throw new ContextNotActiveException("Context with scope annotation @CommandScoped is not active since no UICommand is in execution.");
        }
    }

    static UIContext getCurrentContext() {
        return CONTEXT_STACK.peek();
    }

    private void destroyCurrentContext() {
        Map<Contextual<?>, Object> componentInstanceMap = this.getComponentInstanceMap();
        Map<Contextual<?>, CreationalContext<?>> creationalContextMap = this.getCreationalContextMap();
        if (componentInstanceMap != null && creationalContextMap != null) {
            for (Map.Entry<Contextual<?>, Object> componentEntry : componentInstanceMap.entrySet()) {
                Contextual<?> contextual = componentEntry.getKey();
                Object instance = componentEntry.getValue();
                CreationalContext<?> creational = creationalContextMap.get(contextual);
                contextual.destroy(instance, creational);
            }
        }
    }

    public boolean isActive() {
        return !CONTEXT_STACK.isEmpty();
    }

    public void contextInitialized(UIContext context) {
        CONTEXT_STACK.push(context);
    }

    public void contextDestroyed(UIContext context) {
        this.destroyCurrentContext();
        CONTEXT_STACK.pop();
    }

    private Map<Contextual<?>, Object> getComponentInstanceMap() {
        ConcurrentHashMap map = (ConcurrentHashMap)CommandScopedContext.getCurrentContext().getAttributeMap().get(COMPONENT_MAP_NAME);
        if (map == null) {
            map = new ConcurrentHashMap();
            CommandScopedContext.getCurrentContext().getAttributeMap().put(COMPONENT_MAP_NAME, map);
        }
        return map;
    }

    private Map<Contextual<?>, CreationalContext<?>> getCreationalContextMap() {
        ConcurrentHashMap map = (ConcurrentHashMap)CommandScopedContext.getCurrentContext().getAttributeMap().get(CREATIONAL_MAP_NAME);
        if (map == null) {
            map = new ConcurrentHashMap();
            CommandScopedContext.getCurrentContext().getAttributeMap().put(CREATIONAL_MAP_NAME, map);
        }
        return map;
    }
}

