/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.impl.input;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import org.jboss.forge.addon.ui.impl.input.AbstractUISelectInputComponent;
import org.jboss.forge.addon.ui.input.UISelectMany;
import org.jboss.forge.addon.ui.input.ValueChangeListener;
import org.jboss.forge.addon.ui.util.InputComponents;
import org.jboss.forge.furnace.util.Callables;

public class UISelectManyImpl<VALUETYPE>
extends AbstractUISelectInputComponent<UISelectMany<VALUETYPE>, VALUETYPE>
implements UISelectMany<VALUETYPE> {
    private Iterable<VALUETYPE> value;
    private Callable<Iterable<VALUETYPE>> defaultValue;

    public UISelectManyImpl(String name, char shortName, Class<VALUETYPE> type) {
        super(name, shortName, type);
    }

    public UISelectMany<VALUETYPE> setValue(Iterable<VALUETYPE> value) {
        Set<ValueChangeListener> listeners = this.getValueChangeListeners();
        if (!listeners.isEmpty() && !InputComponents.areElementsEqual((Iterable)this.getValue(), value)) {
            this.fireValueChangeListeners(value);
        }
        this.value = value;
        return this;
    }

    public UISelectMany<VALUETYPE> setDefaultValue(Callable<Iterable<VALUETYPE>> callback) {
        this.defaultValue = callback;
        return this;
    }

    public UISelectMany<VALUETYPE> setDefaultValue(Iterable<VALUETYPE> value) {
        this.defaultValue = Callables.returning(value);
        return this;
    }

    public Iterable<VALUETYPE> getValue() {
        Iterable iterableValue = this.value == null ? (Iterable)Callables.call(this.defaultValue) : this.value;
        return iterableValue == null ? Collections.emptyList() : iterableValue;
    }

    public boolean hasDefaultValue() {
        Iterable defaultValueValue = (Iterable)Callables.call(this.defaultValue);
        return defaultValueValue != null && defaultValueValue.iterator().hasNext();
    }

    public boolean hasValue() {
        return this.value != null && this.value.iterator().hasNext();
    }

    public String toString() {
        return "UISelectManyImpl [name=" + this.getName() + ", shortName='" + this.getShortName() + "', value=" + this.value + ", defaultValue=" + this.defaultValue + "]";
    }
}

