/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.parser.sparql;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.openrdf.query.algebra.And;
import org.openrdf.query.algebra.Filter;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.LeftJoin;
import org.openrdf.query.algebra.SingletonSet;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.Var;

public class GraphPattern {
    private Var contextVar;
    private StatementPattern.Scope spScope = StatementPattern.Scope.DEFAULT_CONTEXTS;
    private List<TupleExpr> requiredTEs = new ArrayList<TupleExpr>();
    private List<Map.Entry<TupleExpr, List<ValueExpr>>> optionalTEs = new ArrayList<Map.Entry<TupleExpr, List<ValueExpr>>>();
    private List<ValueExpr> constraints = new ArrayList<ValueExpr>();

    public GraphPattern() {
    }

    public GraphPattern(GraphPattern parent) {
        this.contextVar = parent.contextVar;
        this.spScope = parent.spScope;
    }

    public void setContextVar(Var contextVar) {
        this.contextVar = contextVar;
    }

    public Var getContextVar() {
        return this.contextVar;
    }

    public void setStatementPatternScope(StatementPattern.Scope spScope) {
        this.spScope = spScope;
    }

    public StatementPattern.Scope getStatementPatternScope() {
        return this.spScope;
    }

    public void addRequiredTE(TupleExpr te) {
        this.requiredTEs.add(te);
    }

    public void addRequiredSP(Var subjVar, Var predVar, Var objVar) {
        this.addRequiredTE((TupleExpr)new StatementPattern(this.spScope, subjVar, predVar, objVar, this.contextVar));
    }

    public List<TupleExpr> getRequiredTEs() {
        return Collections.unmodifiableList(this.requiredTEs);
    }

    public void addOptionalTE(TupleExpr te, List<ValueExpr> constraints) {
        AbstractMap.SimpleImmutableEntry<TupleExpr, List<ValueExpr>> entry = new AbstractMap.SimpleImmutableEntry<TupleExpr, List<ValueExpr>>(te, constraints);
        this.optionalTEs.add(entry);
    }

    public List<Map.Entry<TupleExpr, List<ValueExpr>>> getOptionalTEs() {
        return Collections.unmodifiableList(this.optionalTEs);
    }

    public void addConstraint(ValueExpr constraint) {
        this.constraints.add(constraint);
    }

    public void addConstraints(Collection<ValueExpr> constraints) {
        this.constraints.addAll(constraints);
    }

    public List<ValueExpr> getConstraints() {
        return Collections.unmodifiableList(this.constraints);
    }

    public List<ValueExpr> removeAllConstraints() {
        List<ValueExpr> constraints = this.constraints;
        this.constraints = new ArrayList<ValueExpr>();
        return constraints;
    }

    public void clear() {
        this.requiredTEs.clear();
        this.optionalTEs.clear();
        this.constraints.clear();
    }

    public TupleExpr buildTupleExpr() {
        SingletonSet result;
        if (this.requiredTEs.isEmpty()) {
            result = new SingletonSet();
        } else {
            result = this.requiredTEs.get(0);
            for (int i = 1; i < this.requiredTEs.size(); ++i) {
                TupleExpr te = this.requiredTEs.get(i);
                result = new Join((TupleExpr)result, te);
            }
        }
        for (Map.Entry<TupleExpr, List<ValueExpr>> entry : this.optionalTEs) {
            List<ValueExpr> constraints = entry.getValue();
            if (constraints != null && !constraints.isEmpty()) {
                ValueExpr condition = constraints.get(0);
                for (int i = 1; i < constraints.size(); ++i) {
                    condition = new And(condition, constraints.get(i));
                }
                result = new LeftJoin((TupleExpr)result, entry.getKey(), condition);
                continue;
            }
            result = new LeftJoin((TupleExpr)result, entry.getKey());
        }
        for (ValueExpr constraint : this.constraints) {
            result = new Filter((TupleExpr)result, constraint);
        }
        return result;
    }
}

