/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.bootstrap;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jboss.forge.furnace.util.OperatingSystemUtils;
import org.jboss.logmanager.ConfigurationLocator;
import org.jboss.windup.bootstrap.Bootstrap;

public class LoggingConfigurationLocator
implements ConfigurationLocator {
    static final FilenameFilter LOGGING_CONFIG_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.equals("logging.properties");
        }
    };

    public InputStream findConfiguration() throws IOException {
        String propLoc = System.getProperty("logging.configuration");
        if (propLoc != null) {
            try {
                return new URL(propLoc).openStream();
            }
            catch (IOException e) {
                System.err.printf("Unable to read the logging configuration from '%s' (%s)%n", propLoc, e);
            }
        }
        File[] files = null;
        File userWindupDir = Bootstrap.getUserWindupDir();
        if (userWindupDir.isDirectory() && (files = userWindupDir.listFiles(LOGGING_CONFIG_FILTER)) != null && files.length > 0) {
            return new FileInputStream(files[0]);
        }
        File windupHomeDir = OperatingSystemUtils.getForgeHomeDir();
        if (windupHomeDir.isDirectory()) {
            files = windupHomeDir.listFiles(LOGGING_CONFIG_FILTER);
        }
        if (files != null && files.length > 0) {
            return new FileInputStream(files[0]);
        }
        System.err.println("No logging configuration was found.");
        return null;
    }
}

