/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.configuration;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.attribute.Duration;
import com.thinkaurelius.titan.core.schema.TitanConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigElement;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigNamespace;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.ReadConfiguration;
import java.lang.reflect.Array;

public class UserModifiableConfiguration
implements TitanConfiguration {
    private final ModifiableConfiguration config;
    private final ConfigVerifier verifier;
    public static final ConfigVerifier ALLOW_ALL = new ConfigVerifier(){

        @Override
        public void verifyModification(ConfigOption option) {
        }
    };

    public UserModifiableConfiguration(ModifiableConfiguration config) {
        this(config, ALLOW_ALL);
    }

    public UserModifiableConfiguration(ModifiableConfiguration config, ConfigVerifier verifier) {
        Preconditions.checkArgument((config != null && verifier != null ? 1 : 0) != 0);
        this.config = config;
        this.verifier = verifier;
    }

    public ReadConfiguration getConfiguration() {
        return this.config.getConfiguration();
    }

    @Override
    public String get(String path) {
        ConfigElement.PathIdentifier pp = ConfigElement.parse(this.config.getRootNamespace(), path);
        if (pp.element.isNamespace()) {
            ConfigNamespace ns = (ConfigNamespace)pp.element;
            StringBuilder s = new StringBuilder();
            if (ns.isUmbrella() && !pp.lastIsUmbrella) {
                for (String sub : this.config.getContainedNamespaces(ns, pp.umbrellaElements)) {
                    s.append("+ ").append(sub).append("\n");
                }
            }
            return s.toString();
        }
        if (!this.config.has((ConfigOption)pp.element, pp.umbrellaElements) && ((ConfigOption)pp.element).getDefaultValue() == null) {
            return "null";
        }
        Object value = this.config.get((ConfigOption)pp.element, pp.umbrellaElements);
        Preconditions.checkNotNull(value);
        if (value.getClass().isArray()) {
            StringBuilder s = new StringBuilder();
            s.append("[");
            for (int i = 0; i < Array.getLength(value); ++i) {
                if (i > 0) {
                    s.append(",");
                }
                s.append(Array.get(value, i));
            }
            s.append("]");
            return s.toString();
        }
        return String.valueOf(value);
    }

    @Override
    public UserModifiableConfiguration set(String path, Object value) {
        ConfigElement.PathIdentifier pp = ConfigElement.parse(this.config.getRootNamespace(), path);
        Preconditions.checkArgument((boolean)pp.element.isOption(), (String)"Need to provide configuration option - not namespace: %s", (Object[])new Object[]{path});
        ConfigOption option = (ConfigOption)pp.element;
        this.verifier.verifyModification(option);
        if (option.getDatatype().isArray()) {
            Object arr;
            Class<?> arrayType = option.getDatatype().getComponentType();
            if (value.getClass().isArray()) {
                int size = Array.getLength(value);
                arr = Array.newInstance(arrayType, size);
                for (int i = 0; i < size; ++i) {
                    Array.set(arr, i, UserModifiableConfiguration.convertBasic(Array.get(value, i), arrayType));
                }
            } else {
                arr = Array.newInstance(arrayType, 1);
                Array.set(arr, 0, UserModifiableConfiguration.convertBasic(value, arrayType));
            }
            value = arr;
        } else {
            value = UserModifiableConfiguration.convertBasic(value, option.getDatatype());
        }
        this.config.set(option, value, pp.umbrellaElements);
        return this;
    }

    public void close() {
        this.config.close();
    }

    private static final Object convertBasic(Object value, Class datatype) {
        if (Number.class.isAssignableFrom(datatype)) {
            Preconditions.checkArgument((boolean)(value instanceof Number), (String)"Expected a number but got: %s", (Object[])new Object[]{value});
            Number n = (Number)value;
            if (datatype == Long.class) {
                return n.longValue();
            }
            if (datatype == Integer.class) {
                return n.intValue();
            }
            if (datatype == Short.class) {
                return n.shortValue();
            }
            if (datatype == Byte.class) {
                return n.byteValue();
            }
            if (datatype == Float.class) {
                return Float.valueOf(n.floatValue());
            }
            if (datatype == Double.class) {
                return n.doubleValue();
            }
            throw new IllegalArgumentException("Unexpected number data type: " + datatype);
        }
        if (datatype == Boolean.class) {
            Preconditions.checkArgument((boolean)(value instanceof Boolean), (String)"Expected boolean value: %s", (Object[])new Object[]{value});
            return value;
        }
        if (datatype == String.class) {
            Preconditions.checkArgument((boolean)(value instanceof String), (String)"Expected string value: %s", (Object[])new Object[]{value});
            return value;
        }
        if (Duration.class.isAssignableFrom(datatype)) {
            Preconditions.checkArgument((boolean)(value instanceof Duration), (String)"Expected duration value: %s", (Object[])new Object[]{value});
            return value;
        }
        if (datatype.isEnum()) {
            for (Object e : datatype.getEnumConstants()) {
                if (!e.equals(value)) continue;
                return e;
            }
            for (Object e : datatype.getEnumConstants()) {
                if (!e.toString().equals(value.toString())) continue;
                return e;
            }
            throw new IllegalArgumentException("No match for " + value + " in enum " + datatype);
        }
        throw new IllegalArgumentException("Unexpected data type: " + datatype);
    }

    public static interface ConfigVerifier {
        public void verifyModification(ConfigOption var1);
    }
}

