/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.EntryList;
import com.thinkaurelius.titan.diskstorage.EntryMetaData;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.TemporaryBackendException;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyIterator;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyRangeQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeySliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.BaseKeyColumnValueAdapter;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.KVQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.KeyValueEntry;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.OrderedKeyValueStore;
import com.thinkaurelius.titan.diskstorage.util.RecordIterator;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayBuffer;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayEntry;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayEntryList;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderedKeyValueStoreAdapter
extends BaseKeyColumnValueAdapter {
    private final Logger log = LoggerFactory.getLogger(OrderedKeyValueStoreAdapter.class);
    public static final int variableKeyLength = 0;
    public static final int maxVariableKeyLength = Short.MAX_VALUE;
    public static final int variableKeyLengthSize = 2;
    private final OrderedKeyValueStore store;
    private final int keyLength;
    private final StaticArrayEntry.GetColVal<KeyValueEntry, StaticBuffer> kvEntryGetter = new StaticArrayEntry.GetColVal<KeyValueEntry, StaticBuffer>(){

        @Override
        public StaticBuffer getColumn(KeyValueEntry element) {
            return OrderedKeyValueStoreAdapter.this.getColumnFromKey(element.getKey());
        }

        @Override
        public StaticBuffer getValue(KeyValueEntry element) {
            return element.getValue();
        }

        @Override
        public EntryMetaData[] getMetaSchema(KeyValueEntry element) {
            return StaticArrayEntry.EMPTY_SCHEMA;
        }

        @Override
        public Object getMetaData(KeyValueEntry element, EntryMetaData meta) {
            throw new UnsupportedOperationException("Unsupported meta data: " + (Object)((Object)meta));
        }
    };

    public OrderedKeyValueStoreAdapter(OrderedKeyValueStore store) {
        this(store, 0);
    }

    public OrderedKeyValueStoreAdapter(OrderedKeyValueStore store, int keyLength) {
        super(store);
        Preconditions.checkNotNull((Object)store);
        Preconditions.checkArgument((keyLength >= 0 ? 1 : 0) != 0);
        this.store = store;
        this.keyLength = keyLength;
        this.log.debug("Used key length {} for database {}", (Object)keyLength, (Object)store.getName());
    }

    @Override
    public EntryList getSlice(KeySliceQuery query, StoreTransaction txh) throws BackendException {
        return this.convert(this.store.getSlice(this.convertQuery(query), txh));
    }

    @Override
    public Map<StaticBuffer, EntryList> getSlice(List<StaticBuffer> keys, SliceQuery query, StoreTransaction txh) throws BackendException {
        ArrayList<KVQuery> queries = new ArrayList<KVQuery>(keys.size());
        for (int i = 0; i < keys.size(); ++i) {
            queries.add(this.convertQuery(new KeySliceQuery(keys.get(i), query)));
        }
        Map<KVQuery, RecordIterator<KeyValueEntry>> results = this.store.getSlices(queries, txh);
        HashMap<StaticBuffer, EntryList> convResults = new HashMap<StaticBuffer, EntryList>(keys.size());
        assert (queries.size() == keys.size());
        for (int i = 0; i < queries.size(); ++i) {
            convResults.put(keys.get(i), this.convert(results.get(queries.get(i))));
        }
        return convResults;
    }

    @Override
    public void mutate(StaticBuffer key, List<Entry> additions, List<StaticBuffer> deletions, StoreTransaction txh) throws BackendException {
        if (!deletions.isEmpty()) {
            for (StaticBuffer deletion : deletions) {
                StaticBuffer del = this.concatenate(key, deletion.as(StaticBuffer.STATIC_FACTORY));
                this.store.delete(del, txh);
            }
        }
        if (!additions.isEmpty()) {
            for (Entry entry : additions) {
                StaticBuffer newkey = this.concatenate(key, entry.getColumnAs(StaticBuffer.STATIC_FACTORY));
                this.store.insert(newkey, entry.getValueAs(StaticBuffer.STATIC_FACTORY), txh);
            }
        }
    }

    @Override
    public KeyIterator getKeys(final KeyRangeQuery keyQuery, StoreTransaction txh) throws BackendException {
        KVQuery query = new KVQuery(this.concatenatePrefix(keyQuery.getKeyStart(), keyQuery.getSliceStart()), this.concatenatePrefix(keyQuery.getKeyEnd(), keyQuery.getSliceEnd()), new Predicate<StaticBuffer>(){

            public boolean apply(@Nullable StaticBuffer keycolumn) {
                StaticBuffer key = OrderedKeyValueStoreAdapter.this.getKey(keycolumn);
                return key.compareTo(keyQuery.getKeyStart()) >= 0 && key.compareTo(keyQuery.getKeyEnd()) < 0 && OrderedKeyValueStoreAdapter.this.columnInRange(keycolumn, keyQuery.getSliceStart(), keyQuery.getSliceEnd());
            }
        }, Integer.MAX_VALUE);
        return new KeyIteratorImpl(keyQuery, this.store.getSlice(query, txh));
    }

    @Override
    public KeyIterator getKeys(SliceQuery columnQuery, StoreTransaction txh) throws BackendException {
        throw new UnsupportedOperationException("This store has ordered keys, use getKeys(KeyRangeQuery, StoreTransaction) instead");
    }

    @Override
    public void acquireLock(StaticBuffer key, StaticBuffer column, StaticBuffer expectedValue, StoreTransaction txh) throws BackendException {
        this.store.acquireLock(this.concatenate(key, column), expectedValue, txh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntryList convert(RecordIterator<KeyValueEntry> entries) throws BackendException {
        try {
            EntryList entryList = StaticArrayEntryList.ofStaticBuffer(entries, this.kvEntryGetter);
            return entryList;
        }
        finally {
            try {
                entries.close();
            }
            catch (IOException e) {
                throw new TemporaryBackendException(e);
            }
        }
    }

    private Entry getEntry(KeyValueEntry entry) {
        return StaticArrayEntry.ofStaticBuffer(entry, this.kvEntryGetter);
    }

    private boolean hasFixedKeyLength() {
        return this.keyLength > 0;
    }

    private int getLength(StaticBuffer key) {
        int length = this.keyLength;
        if (this.hasFixedKeyLength()) {
            Preconditions.checkArgument((key.length() == length ? 1 : 0) != 0);
        } else {
            length = key.length();
            Preconditions.checkArgument((length < Short.MAX_VALUE ? 1 : 0) != 0);
        }
        return length;
    }

    final KeyValueEntry concatenate(StaticBuffer front, Entry entry) {
        return new KeyValueEntry(this.concatenate(front, entry.getColumnAs(StaticBuffer.STATIC_FACTORY)), entry.getValueAs(StaticBuffer.STATIC_FACTORY));
    }

    final KVQuery convertQuery(final KeySliceQuery query) {
        Predicate filter = Predicates.alwaysTrue();
        if (!this.hasFixedKeyLength()) {
            filter = new Predicate<StaticBuffer>(){

                public boolean apply(@Nullable StaticBuffer keyAndColumn) {
                    return OrderedKeyValueStoreAdapter.this.equalKey(keyAndColumn, query.getKey());
                }
            };
        }
        return new KVQuery(this.concatenatePrefix(query.getKey(), query.getSliceStart()), this.concatenatePrefix(query.getKey(), query.getSliceEnd()), (Predicate<StaticBuffer>)filter, query.getLimit());
    }

    final StaticBuffer concatenate(StaticBuffer front, StaticBuffer end) {
        return this.concatenate(front, end, true);
    }

    private StaticBuffer concatenatePrefix(StaticBuffer front, StaticBuffer end) {
        return this.concatenate(front, end, false);
    }

    private StaticBuffer concatenate(StaticBuffer front, StaticBuffer end, boolean appendLength) {
        int i;
        boolean addKeyLength = !this.hasFixedKeyLength() && appendLength;
        int length = this.getLength(front);
        byte[] result = new byte[length + end.length() + (addKeyLength ? 2 : 0)];
        int position = 0;
        for (i = 0; i < front.length(); ++i) {
            result[position++] = front.getByte(i);
        }
        for (i = 0; i < end.length(); ++i) {
            result[position++] = end.getByte(i);
        }
        if (addKeyLength) {
            result[position++] = (byte)(length >>> 8);
            result[position++] = (byte)length;
        }
        return StaticArrayBuffer.of(result);
    }

    private StaticBuffer getColumnFromKey(StaticBuffer concat) {
        int offset = this.getKeyLength(concat);
        int length = concat.length() - offset;
        if (!this.hasFixedKeyLength()) {
            length -= 2;
        }
        return concat.subrange(offset, length);
    }

    private int getKeyLength(StaticBuffer concat) {
        int length = this.keyLength;
        if (!this.hasFixedKeyLength()) {
            length = concat.getShort(concat.length() - 2);
        }
        return length;
    }

    private StaticBuffer getKey(StaticBuffer concat) {
        return concat.subrange(0, this.getKeyLength(concat));
    }

    private boolean equalKey(StaticBuffer concat, StaticBuffer key) {
        int keylen = this.getKeyLength(concat);
        for (int i = 0; i < keylen; ++i) {
            if (concat.getByte(i) == key.getByte(i)) continue;
            return false;
        }
        return true;
    }

    private boolean columnInRange(StaticBuffer concat, StaticBuffer columnStart, StaticBuffer columnEnd) {
        StaticBuffer column = this.getColumnFromKey(concat);
        return column.compareTo(columnStart) >= 0 && column.compareTo(columnEnd) < 0;
    }

    private class KeyIteratorImpl
    implements KeyIterator {
        private final KeyRangeQuery query;
        private final RecordIterator<KeyValueEntry> iter;
        private StaticBuffer currentKey = null;
        private EntryIterator currentIter = null;
        private boolean currentKeyReturned = true;
        private KeyValueEntry current;

        private KeyIteratorImpl(KeyRangeQuery query, RecordIterator<KeyValueEntry> iter) {
            this.query = query;
            this.iter = iter;
        }

        private StaticBuffer nextKey() throws BackendException {
            while (this.iter.hasNext()) {
                this.current = (KeyValueEntry)this.iter.next();
                StaticBuffer key = OrderedKeyValueStoreAdapter.this.getKey(this.current.getKey());
                if (this.currentKey != null && key.equals(this.currentKey)) continue;
                return key;
            }
            return null;
        }

        @Override
        public RecordIterator<Entry> getEntries() {
            Preconditions.checkNotNull((Object)this.currentIter);
            return this.currentIter;
        }

        @Override
        public boolean hasNext() {
            if (this.currentKeyReturned) {
                try {
                    this.currentKey = this.nextKey();
                }
                catch (BackendException e) {
                    throw new RuntimeException(e);
                }
                this.currentKeyReturned = false;
                if (this.currentIter != null) {
                    this.currentIter.close();
                }
                this.currentIter = new EntryIterator();
            }
            return this.currentKey != null;
        }

        @Override
        public StaticBuffer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.currentKeyReturned = true;
            return this.currentKey;
        }

        @Override
        public void close() throws IOException {
            this.iter.close();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private class EntryIterator
        implements RecordIterator<Entry>,
        Closeable {
            private boolean open = true;
            private int count = 0;

            private EntryIterator() {
            }

            @Override
            public boolean hasNext() {
                Preconditions.checkState((boolean)this.open);
                if (KeyIteratorImpl.this.current == null || this.count >= KeyIteratorImpl.this.query.getLimit()) {
                    return false;
                }
                StaticBuffer nextKey = OrderedKeyValueStoreAdapter.this.getKey(KeyIteratorImpl.this.current.getKey());
                if (!nextKey.equals(KeyIteratorImpl.this.currentKey)) {
                    KeyIteratorImpl.this.currentKey = nextKey;
                    KeyIteratorImpl.this.currentKeyReturned = false;
                    return false;
                }
                return true;
            }

            @Override
            public Entry next() {
                Preconditions.checkState((boolean)this.open);
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Entry kve = OrderedKeyValueStoreAdapter.this.getEntry(KeyIteratorImpl.this.current);
                KeyIteratorImpl.this.current = KeyIteratorImpl.this.iter.hasNext() ? (KeyValueEntry)KeyIteratorImpl.this.iter.next() : null;
                ++this.count;
                return kve;
            }

            @Override
            public void close() {
                this.open = false;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

