/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.idassigner.placement;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionIDRange {
    private static final Logger log = LoggerFactory.getLogger(PartitionIDRange.class);
    private static final Random random = new Random();
    private final int lowerID;
    private final int upperID;
    private final int idUpperBound;

    public PartitionIDRange(int lowerID, int upperID, int idUpperBound) {
        Preconditions.checkArgument((idUpperBound > 0 ? 1 : 0) != 0, (Object)("Partition limit " + idUpperBound + " must be positive"));
        Preconditions.checkArgument((idUpperBound <= Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"Partition limit cannot exceed representable range of an integer");
        Preconditions.checkArgument((lowerID >= 0 ? 1 : 0) != 0, (Object)("Negative partition lower bound " + lowerID));
        Preconditions.checkArgument((lowerID < idUpperBound ? 1 : 0) != 0, (Object)("Partition lower bound " + lowerID + " exceeds limit " + idUpperBound));
        Preconditions.checkArgument((upperID >= 0 ? 1 : 0) != 0, (Object)("Negative partition upper bound " + upperID));
        Preconditions.checkArgument((upperID <= idUpperBound ? 1 : 0) != 0, (Object)("Partition upper bound " + upperID + " exceeds limit " + idUpperBound));
        this.lowerID = lowerID;
        this.upperID = upperID;
        this.idUpperBound = idUpperBound;
    }

    public int getLowerID() {
        return this.lowerID;
    }

    public int getUpperID() {
        return this.upperID;
    }

    public int getIdUpperBound() {
        return this.idUpperBound;
    }

    public int[] getAllContainedIDs() {
        int[] result;
        if (this.lowerID < this.upperID) {
            result = new int[this.upperID - this.lowerID];
            int pos = 0;
            int id = this.lowerID;
            while (id < this.upperID) {
                result[pos++] = id++;
            }
        } else {
            result = new int[this.idUpperBound - this.lowerID + this.upperID];
            int pos = 0;
            int id = 0;
            while (id < this.upperID) {
                result[pos++] = id++;
            }
            id = this.lowerID;
            while (id < this.idUpperBound) {
                result[pos++] = id++;
            }
        }
        return result;
    }

    public boolean contains(int partitionId) {
        if (this.lowerID < this.upperID) {
            return this.lowerID <= partitionId && this.upperID > partitionId;
        }
        return this.lowerID <= partitionId && partitionId < this.idUpperBound || this.upperID > partitionId && partitionId >= 0;
    }

    public String toString() {
        return "[" + this.lowerID + "," + this.upperID + ")%" + this.idUpperBound;
    }

    public int getRandomID() {
        int partitionWidth = this.lowerID < this.upperID ? this.upperID - this.lowerID : this.idUpperBound - this.lowerID + this.upperID;
        Preconditions.checkArgument((partitionWidth > 0 ? 1 : 0) != 0, (Object)partitionWidth);
        return (random.nextInt(partitionWidth) + this.lowerID) % this.idUpperBound;
    }

    public static List<PartitionIDRange> getGlobalRange(int partitionBits) {
        Preconditions.checkArgument((partitionBits >= 0 && partitionBits < 31 ? 1 : 0) != 0, (String)"Invalid partition bits: %s", (Object[])new Object[]{partitionBits});
        int partitionIdBound = 1 << partitionBits;
        return ImmutableList.of((Object)new PartitionIDRange(0, partitionIdBound, partitionIdBound));
    }

    public static List<PartitionIDRange> getIDRanges(int partitionBits, List<KeyRange> locals) {
        Preconditions.checkArgument((partitionBits > 0 && partitionBits < 31 ? 1 : 0) != 0);
        Preconditions.checkArgument((locals != null && !locals.isEmpty() ? 1 : 0) != 0, (Object)"KeyRanges are empty");
        int partitionIdBound = 1 << partitionBits;
        int backShift = 32 - partitionBits;
        ArrayList partitionRanges = Lists.newArrayList();
        for (KeyRange local : locals) {
            int upperID;
            Preconditions.checkArgument((local.getStart().length() >= 4 ? 1 : 0) != 0);
            Preconditions.checkArgument((local.getEnd().length() >= 4 ? 1 : 0) != 0);
            if (local.getStart().equals(local.getEnd())) {
                partitionRanges.add(new PartitionIDRange(0, partitionIdBound, partitionIdBound));
                continue;
            }
            int startInt = local.getStart().getInt(0);
            int lowerID = startInt >>> backShift;
            assert (lowerID >= 0 && lowerID < partitionIdBound);
            boolean truncatedBits = lowerID << backShift != startInt;
            StaticBuffer start = local.getAt(0);
            for (int i = 4; i < start.length() && !truncatedBits; ++i) {
                if (start.getByte(i) == 0) continue;
                truncatedBits = true;
            }
            if (truncatedBits) {
                ++lowerID;
            }
            if ((lowerID %= partitionIdBound) == (upperID = local.getEnd().getInt(0) >>> backShift) || Math.signum(Integer.compare(lowerID, upperID)) != Math.signum(local.getStart().compareTo(local.getEnd()))) {
                log.warn("Individual key range is too small for partition block - result would be empty: {}", (Object)local);
                continue;
            }
            partitionRanges.add(new PartitionIDRange(lowerID, upperID, partitionIdBound));
        }
        return partitionRanges;
    }
}

