/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query.condition;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanElement;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.graphdb.query.condition.Literal;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class RelationTypeCondition<E extends TitanElement>
extends Literal<E> {
    private final RelationType relationType;

    public RelationTypeCondition(RelationType relationType) {
        Preconditions.checkNotNull((Object)relationType);
        this.relationType = relationType;
    }

    @Override
    public boolean evaluate(E element) {
        Preconditions.checkArgument((boolean)(element instanceof TitanRelation));
        return this.relationType.equals(((TitanRelation)element).getType());
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getType()).append((Object)this.relationType).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other != null && this.getClass().isInstance(other) && this.relationType.equals(((RelationTypeCondition)other).relationType);
    }

    @Override
    public String toString() {
        return "type[" + this.relationType.toString() + "]";
    }
}

