/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.relations;

import com.carrotsearch.hppc.cursors.LongObjectCursor;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.schema.ConsistencyModifier;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.graphdb.internal.InternalRelation;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.relations.AbstractEdge;
import com.thinkaurelius.titan.graphdb.relations.RelationCache;
import com.thinkaurelius.titan.graphdb.relations.StandardEdge;
import com.thinkaurelius.titan.graphdb.transaction.RelationConstructor;
import com.thinkaurelius.titan.graphdb.types.system.ImplicitKey;
import com.tinkerpop.blueprints.Direction;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class CacheEdge
extends AbstractEdge {
    private final Entry data;

    public CacheEdge(long id, EdgeLabel label, InternalVertex start, InternalVertex end, Entry data) {
        super(id, label, start.it(), end.it());
        assert (data != null);
        this.data = data;
    }

    public Direction getVertexCentricDirection() {
        return this.data.getCache().direction;
    }

    @Override
    public InternalRelation it() {
        InternalRelation it = null;
        InternalVertex startVertex = this.getVertex(0);
        if (startVertex.hasAddedRelations() && startVertex.hasRemovedRelations()) {
            final long id = super.getLongId();
            List<InternalRelation> previous = startVertex.getAddedRelations(new Predicate<InternalRelation>(){

                public boolean apply(@Nullable InternalRelation internalRelation) {
                    return internalRelation instanceof StandardEdge && ((StandardEdge)internalRelation).getPreviousID() == id;
                }
            });
            assert (Iterables.size(previous) <= 1 || this.isLoop() && Iterables.size(previous) == 2);
            it = (InternalRelation)Iterables.getFirst(previous, null);
        }
        if (it != null) {
            return it;
        }
        return super.it();
    }

    private void copyProperties(InternalRelation to) {
        for (LongObjectCursor<Object> entry : this.getPropertyMap()) {
            RelationType type = this.tx().getExistingRelationType(entry.key);
            if (type instanceof ImplicitKey) continue;
            to.setPropertyDirect(type, entry.value);
        }
    }

    private synchronized InternalRelation update() {
        StandardEdge copy = new StandardEdge(super.getLongId(), this.getEdgeLabel(), this.getVertex(0), this.getVertex(1), 2);
        this.copyProperties(copy);
        copy.remove();
        StandardEdge u = (StandardEdge)this.tx().addEdge((TitanVertex)this.getVertex(0), (TitanVertex)this.getVertex(1), this.getLabel());
        if (this.type.getConsistencyModifier() != ConsistencyModifier.FORK) {
            u.setId(super.getLongId());
        }
        u.setPreviousID(super.getLongId());
        this.copyProperties(u);
        this.setId(u.getLongId());
        return u;
    }

    private RelationCache getPropertyMap() {
        RelationCache map = this.data.getCache();
        if (map == null || !map.hasProperties()) {
            map = RelationConstructor.readRelationCache(this.data, this.tx());
        }
        return map;
    }

    @Override
    public <O> O getPropertyDirect(RelationType type) {
        return this.getPropertyMap().get(type.getLongId());
    }

    @Override
    public Iterable<RelationType> getPropertyKeysDirect() {
        RelationCache map = this.getPropertyMap();
        ArrayList<RelationType> types = new ArrayList<RelationType>(map.numProperties());
        for (LongObjectCursor<Object> entry : map) {
            types.add(this.tx().getExistingRelationType(entry.key));
        }
        return types;
    }

    @Override
    public void setPropertyDirect(RelationType type, Object value) {
        this.update().setPropertyDirect(type, value);
    }

    @Override
    public <O> O removePropertyDirect(RelationType type) {
        return this.update().removePropertyDirect(type);
    }

    @Override
    public byte getLifeCycle() {
        InternalVertex startVertex = this.getVertex(0);
        return (byte)((startVertex.hasRemovedRelations() || startVertex.isRemoved()) && this.tx().isRemovedRelation(super.getLongId()) ? 6 : 2);
    }

    @Override
    public void remove() {
        if (!this.tx().isRemovedRelation(super.getLongId())) {
            this.tx().removeRelation(this);
        }
    }
}

