/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.relations;

import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.graphdb.internal.InternalRelation;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.query.vertex.VertexCentricQueryBuilder;
import com.thinkaurelius.titan.graphdb.relations.StandardRelation;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.util.encoding.LongEncoding;
import com.tinkerpop.blueprints.Direction;
import java.util.Arrays;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class RelationIdentifier {
    public static final String TOSTRING_DELIMITER = "-";
    private final long outVertexId;
    private final long typeId;
    private final long relationId;
    private final long inVertexId;

    private RelationIdentifier(long outVertexId, long typeId, long relationId, long inVertexId) {
        this.outVertexId = outVertexId;
        this.typeId = typeId;
        this.relationId = relationId;
        this.inVertexId = inVertexId;
    }

    static final RelationIdentifier get(InternalRelation r) {
        if (r.hasId()) {
            return new RelationIdentifier(r.getVertex(0).getLongId(), r.getType().getLongId(), r.getLongId(), r.isEdge() ? r.getVertex(1).getLongId() : 0L);
        }
        return null;
    }

    public long getRelationId() {
        return this.relationId;
    }

    public static final RelationIdentifier get(long[] ids) {
        if (ids.length != 3 && ids.length != 4) {
            throw new IllegalArgumentException("Not a valid relation identifier: " + Arrays.toString(ids));
        }
        for (int i = 0; i < 3; ++i) {
            if (ids[i] >= 0L) continue;
            throw new IllegalArgumentException("Not a valid relation identifier: " + Arrays.toString(ids));
        }
        return new RelationIdentifier(ids[1], ids[2], ids[0], ids.length == 4 ? ids[3] : 0L);
    }

    public static final RelationIdentifier get(int[] ids) {
        if (ids.length != 3 && ids.length != 4) {
            throw new IllegalArgumentException("Not a valid relation identifier: " + Arrays.toString(ids));
        }
        for (int i = 0; i < 3; ++i) {
            if (ids[i] >= 0) continue;
            throw new IllegalArgumentException("Not a valid relation identifier: " + Arrays.toString(ids));
        }
        return new RelationIdentifier(ids[1], ids[2], ids[0], ids.length == 4 ? (long)ids[3] : 0L);
    }

    public long[] getLongRepresentation() {
        long[] r = new long[3 + (this.inVertexId != 0L ? 1 : 0)];
        r[0] = this.relationId;
        r[1] = this.outVertexId;
        r[2] = this.typeId;
        if (this.inVertexId != 0L) {
            r[3] = this.inVertexId;
        }
        return r;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.outVertexId).append(this.typeId).append(this.relationId).append(this.inVertexId).toHashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!this.getClass().isInstance(other)) {
            return false;
        }
        RelationIdentifier oth = (RelationIdentifier)other;
        return this.relationId == oth.relationId && this.outVertexId == oth.outVertexId && this.typeId == oth.typeId && this.inVertexId == oth.inVertexId;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(LongEncoding.encode(this.relationId)).append(TOSTRING_DELIMITER).append(LongEncoding.encode(this.outVertexId)).append(TOSTRING_DELIMITER).append(LongEncoding.encode(this.typeId));
        if (this.inVertexId != 0L) {
            s.append(TOSTRING_DELIMITER).append(LongEncoding.encode(this.inVertexId));
        }
        return s.toString();
    }

    public static final RelationIdentifier parse(String id) {
        String[] elements = id.split(TOSTRING_DELIMITER);
        if (elements.length != 3 && elements.length != 4) {
            throw new IllegalArgumentException("Not a valid relation identifier: " + id);
        }
        try {
            return new RelationIdentifier(LongEncoding.decode(elements[1]), LongEncoding.decode(elements[2]), LongEncoding.decode(elements[0]), elements.length == 4 ? LongEncoding.decode(elements[3]) : 0L);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid id - each token expected to be a number", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    TitanRelation findRelation(TitanTransaction tx) {
        Iterable<TitanRelation> rels;
        InternalVertex v = ((StandardTitanTx)tx).getInternalVertex(this.outVertexId);
        if (v == null || v.isRemoved()) {
            return null;
        }
        TitanVertex typeVertex = tx.getVertex(this.typeId);
        if (typeVertex == null) {
            return null;
        }
        if (!(typeVertex instanceof RelationType)) {
            throw new IllegalArgumentException("Invalid RelationIdentifier: typeID does not reference a type");
        }
        RelationType type = (RelationType)typeVertex;
        if (((RelationType)typeVertex).isEdgeLabel()) {
            void var7_8;
            Direction dir = Direction.OUT;
            InternalVertex internalVertex = ((StandardTitanTx)tx).getInternalVertex(this.inVertexId);
            if (internalVertex == null || internalVertex.isRemoved()) {
                return null;
            }
            if (((StandardTitanTx)tx).isPartitionedVertex(v) && !((StandardTitanTx)tx).isPartitionedVertex(internalVertex)) {
                InternalVertex tmp = internalVertex;
                InternalVertex internalVertex2 = v;
                v = tmp;
                dir = Direction.IN;
            }
            rels = ((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)v.query()).noPartitionRestriction()).types((EdgeLabel)type)).direction(dir)).adjacent((TitanVertex)var7_8)).titanEdges();
        } else {
            rels = ((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)v.query()).noPartitionRestriction()).types((PropertyKey)type)).properties();
        }
        for (TitanRelation titanRelation : rels) {
            if (titanRelation.getLongId() != this.relationId && (!(titanRelation instanceof StandardRelation) || ((StandardRelation)titanRelation).getPreviousID() != this.relationId)) continue;
            return titanRelation;
        }
        return null;
    }

    public TitanEdge findEdge(TitanTransaction tx) {
        TitanRelation r = this.findRelation(tx);
        if (r == null) {
            return null;
        }
        if (r instanceof TitanEdge) {
            return (TitanEdge)r;
        }
        throw new UnsupportedOperationException("Referenced relation is a property not an edge");
    }

    public TitanProperty findProperty(TitanTransaction tx) {
        TitanRelation r = this.findRelation(tx);
        if (r == null) {
            return null;
        }
        if (r instanceof TitanProperty) {
            return (TitanProperty)r;
        }
        throw new UnsupportedOperationException("Referenced relation is a edge not a property");
    }
}

