/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.types.system;

import com.google.common.collect.ImmutableMap;
import com.thinkaurelius.titan.graphdb.types.system.BaseKey;
import com.thinkaurelius.titan.graphdb.types.system.BaseLabel;
import com.thinkaurelius.titan.graphdb.types.system.ImplicitKey;
import com.thinkaurelius.titan.graphdb.types.system.SystemRelationType;
import java.util.Map;

public abstract class SystemTypeManager {
    public static final String systemETprefix = "system%&%";
    private static volatile Map<Long, SystemRelationType> SYSTEM_TYPES_BY_ID;
    private static volatile Map<String, SystemRelationType> SYSTEM_TYPES_BY_NAME;

    public static SystemRelationType getSystemType(long id) {
        return SYSTEM_TYPES_BY_ID.get(id);
    }

    public static SystemRelationType getSystemType(String name) {
        return SYSTEM_TYPES_BY_NAME.get(name);
    }

    public static boolean isSystemType(String name) {
        return SYSTEM_TYPES_BY_NAME.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<SystemTypeManager> clazz = SystemTypeManager.class;
        synchronized (SystemTypeManager.class) {
            ImmutableMap.Builder idBuilder = ImmutableMap.builder();
            ImmutableMap.Builder nameBuilder = ImmutableMap.builder();
            for (SystemRelationType et : new SystemRelationType[]{BaseKey.SchemaCategory, BaseKey.SchemaDefinitionDesc, BaseKey.SchemaDefinitionProperty, BaseKey.SchemaName, BaseKey.SchemaUpdateTime, BaseKey.VertexExists, BaseLabel.VertexLabelEdge, BaseLabel.SchemaDefinitionEdge, ImplicitKey.ID, ImplicitKey.TITANID, ImplicitKey.LABEL, ImplicitKey.ADJACENT_ID, ImplicitKey.TIMESTAMP, ImplicitKey.TTL, ImplicitKey.VISIBILITY}) {
                idBuilder.put((Object)et.getLongId(), (Object)et);
                nameBuilder.put((Object)et.getName(), (Object)et);
            }
            SYSTEM_TYPES_BY_ID = idBuilder.build();
            SYSTEM_TYPES_BY_NAME = nameBuilder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            assert (SYSTEM_TYPES_BY_ID.size() == 15);
            assert (SYSTEM_TYPES_BY_NAME.size() == 15);
            return;
        }
    }
}

