/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.ip;

import org.apache.commons.validator.routines.InetAddressValidator;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.MigrationRulesPhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.java.ip.StaticIPLocationModel;
import org.jboss.windup.rules.files.condition.FileContent;
import org.jboss.windup.rules.files.model.FileLocationModel;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class DiscoverStaticIPAddressRuleProvider
extends AbstractRuleProvider {
    public DiscoverStaticIPAddressRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(DiscoverStaticIPAddressRuleProvider.class).setPhase(MigrationRulesPhase.class));
    }

    public Configuration getConfiguration(GraphContext context) {
        return ConfigurationBuilder.begin().addRule().when((Condition)FileContent.matches((String)"{ip}").inFileNamed("{*}.{type}")).perform((Operation)new AbstractIterationOperation<FileLocationModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, FileLocationModel payload) {
                if (InetAddressValidator.getInstance().isValid(payload.getSourceSnippit())) {
                    StaticIPLocationModel location = (StaticIPLocationModel)GraphService.addTypeToModel((GraphContext)event.getGraphContext(), (WindupVertexFrame)payload, StaticIPLocationModel.class);
                    location.setRuleID(((Rule)context.get(Rule.class)).getId());
                    location.setTitle("Static IP Address Detected");
                    StringBuilder hintBody = new StringBuilder("**Static IP: ");
                    hintBody.append(payload.getSourceSnippit());
                    hintBody.append("**");
                    hintBody.append("\n\n");
                    hintBody.append("When migrating environments, static IP addresses may need to be modified or eliminated.");
                    location.setHint(hintBody.toString());
                    location.setEffort(0);
                }
            }
        }).where("ip").matches("(?<![\\w.])\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}(?![\\w.])").where("type").matches("java|properties|xml").withId(((Object)((Object)this)).getClass().getSimpleName());
    }
}

