/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.reporting.freemarker;

import com.tinkerpop.blueprints.Vertex;
import freemarker.ext.beans.StringModel;
import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.reporting.model.ClassificationModel;
import org.jboss.windup.reporting.model.InlineHintModel;
import org.jboss.windup.reporting.query.FindFilesNotClassifiedOrHintedGremlinCriterion;
import org.jboss.windup.rules.apps.java.model.JavaClassFileModel;
import org.jboss.windup.rules.apps.java.model.JavaSourceFileModel;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.util.ExecutionStatistics;

public class FindFilesNotClassifiedOrHinted
implements WindupFreeMarkerMethod {
    private static final String NAME = "findFilesNotClassifiedOrHinted";
    private GraphContext context;

    public void setContext(GraphRewrite event) {
        this.context = event.getGraphContext();
    }

    public Object exec(List arguments) throws TemplateModelException {
        ExecutionStatistics.get().begin(NAME);
        if (arguments.size() != 1) {
            throw new TemplateModelException("Error, method expects one argument (Iterable<FileModel>)");
        }
        StringModel stringModelArg = (StringModel)arguments.get(0);
        Iterable fileModels = (Iterable)stringModelArg.getWrappedObject();
        FindFilesNotClassifiedOrHintedGremlinCriterion criterion = new FindFilesNotClassifiedOrHintedGremlinCriterion();
        ArrayList<Vertex> initialFileModelsAsVertices = new ArrayList<Vertex>();
        for (FileModel fm : fileModels) {
            initialFileModelsAsVertices.add(fm.asVertex());
        }
        Iterable result = criterion.query(this.context, initialFileModelsAsVertices);
        ArrayList<FileModel> resultModels = new ArrayList<FileModel>();
        for (Vertex v : result) {
            FileModel f = (FileModel)this.context.getFramed().frame(v, FileModel.class);
            if (!(f instanceof JavaSourceFileModel) && !(f instanceof XmlFileModel) && !(f instanceof JavaClassFileModel)) continue;
            resultModels.add(f);
        }
        ExecutionStatistics.get().end(NAME);
        return resultModels;
    }

    public String getMethodName() {
        return NAME;
    }

    public String getDescription() {
        return "Takes an Iterable<" + FileModel.class.getSimpleName() + "> as a parameter and returns the files that have neither " + ClassificationModel.class.getSimpleName() + "s nor " + InlineHintModel.class.getSimpleName() + "s associated with them.";
    }
}

