/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.sesametools;

import info.aduna.iteration.CloseableIteration;
import net.fortytwo.sesametools.EmptyCloseableIteration;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.SailBase;
import org.openrdf.sail.helpers.SailConnectionBase;

class SingleContextSailConnection
extends SailConnectionBase {
    private SailConnection baseSailConnection;
    private Resource singleContext;

    public SingleContextSailConnection(SailBase sail, Sail baseSail, Resource context) throws SailException {
        super(sail);
        this.baseSailConnection = baseSail.getConnection();
        this.singleContext = context;
    }

    protected void addStatementInternal(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        if (0 == contexts.length) {
            this.baseSailConnection.addStatement(subj, pred, obj, new Resource[]{this.singleContext});
        } else {
            for (Resource context : contexts) {
                if (null == context || !context.equals(this.singleContext)) continue;
                this.baseSailConnection.addStatement(subj, pred, obj, new Resource[]{this.singleContext});
                break;
            }
        }
    }

    protected void clearInternal(Resource ... contexts) throws SailException {
        if (0 == contexts.length) {
            this.baseSailConnection.clear(new Resource[]{this.singleContext});
        } else {
            for (Resource context : contexts) {
                if (null == context || !context.equals(this.singleContext)) continue;
                this.baseSailConnection.clear(new Resource[]{this.singleContext});
                break;
            }
        }
    }

    protected void clearNamespacesInternal() throws SailException {
        this.baseSailConnection.clearNamespaces();
    }

    protected void startTransactionInternal() throws SailException {
        this.baseSailConnection.begin();
    }

    protected void closeInternal() throws SailException {
        this.baseSailConnection.close();
    }

    protected void commitInternal() throws SailException {
        this.baseSailConnection.commit();
    }

    protected CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluateInternal(TupleExpr tupleExpr, Dataset dataSet, BindingSet bindingSet, boolean includeInferred) throws SailException {
        DatasetImpl singleContextDataset = new DatasetImpl();
        if (this.singleContext instanceof URI) {
            singleContextDataset.setDefaultInsertGraph((URI)this.singleContext);
            singleContextDataset.addDefaultGraph((URI)this.singleContext);
            singleContextDataset.addNamedGraph((URI)this.singleContext);
            singleContextDataset.addDefaultRemoveGraph((URI)this.singleContext);
        }
        return this.baseSailConnection.evaluate(tupleExpr, (Dataset)singleContextDataset, bindingSet, includeInferred);
    }

    protected CloseableIteration<? extends Resource, SailException> getContextIDsInternal() throws SailException {
        return new SingleContextIteration();
    }

    protected String getNamespaceInternal(String prefix) throws SailException {
        return this.baseSailConnection.getNamespace(prefix);
    }

    protected CloseableIteration<? extends Namespace, SailException> getNamespacesInternal() throws SailException {
        return this.baseSailConnection.getNamespaces();
    }

    protected CloseableIteration<? extends Statement, SailException> getStatementsInternal(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        if (0 == contexts.length) {
            return this.baseSailConnection.getStatements(subj, pred, obj, includeInferred, new Resource[]{this.singleContext});
        }
        for (Resource context : contexts) {
            if (null == context || !context.equals(this.singleContext)) continue;
            return this.baseSailConnection.getStatements(subj, pred, obj, includeInferred, new Resource[]{this.singleContext});
        }
        return new EmptyCloseableIteration();
    }

    protected void removeNamespaceInternal(String prefix) throws SailException {
        this.baseSailConnection.removeNamespace(prefix);
    }

    protected void removeStatementsInternal(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        if (0 == contexts.length) {
            this.baseSailConnection.removeStatements(subj, pred, obj, new Resource[]{this.singleContext});
        } else {
            for (Resource context : contexts) {
                if (null == context || !context.equals(this.singleContext)) continue;
                this.baseSailConnection.removeStatements(subj, pred, obj, new Resource[]{this.singleContext});
                break;
            }
        }
    }

    protected void rollbackInternal() throws SailException {
        this.baseSailConnection.rollback();
    }

    protected void setNamespaceInternal(String prefix, String name) throws SailException {
        this.baseSailConnection.setNamespace(prefix, name);
    }

    protected long sizeInternal(Resource ... contexts) throws SailException {
        if (0 == contexts.length) {
            return this.baseSailConnection.size(new Resource[]{this.singleContext});
        }
        for (Resource context : contexts) {
            if (null == context || !context.equals(this.singleContext)) continue;
            return this.baseSailConnection.size(new Resource[]{this.singleContext});
        }
        return 0L;
    }

    private class SingleContextIteration
    implements CloseableIteration<Resource, SailException> {
        private Resource nextContext;

        public SingleContextIteration() {
            this.nextContext = SingleContextSailConnection.this.singleContext;
        }

        public void close() throws SailException {
        }

        public boolean hasNext() throws SailException {
            return null != this.nextContext;
        }

        public Resource next() throws SailException {
            Resource r = this.nextContext;
            this.nextContext = null;
            return r;
        }

        public void remove() throws SailException {
        }
    }
}

