/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.ast.java.data.ClassReference;
import org.jboss.windup.ast.java.data.ResolutionStatus;
import org.jboss.windup.ast.java.data.TypeReferenceLocation;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.scan.ast.JavaTypeReferenceModel;
import org.jboss.windup.rules.apps.java.scan.ast.TypeInterestFactory;
import org.jboss.windup.rules.apps.java.service.JavaClassService;
import org.jboss.windup.rules.apps.java.service.TypeReferenceService;
import org.jboss.windup.rules.apps.javaee.model.JspSourceFileModel;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class AnalyzeJSPFileRuleProvider
extends AbstractRuleProvider {
    public AnalyzeJSPFileRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(AnalyzeJSPFileRuleProvider.class).setPhase(InitialAnalysisPhase.class).setHaltOnException(true));
    }

    public Configuration getConfiguration(GraphContext context) {
        return ConfigurationBuilder.begin().addRule().when((Condition)Query.fromType(JspSourceFileModel.class)).perform((Operation)new ParseSourceOperation());
    }

    private Iterable<ClassReference> getClassReferences(TypeReferenceService service, JspSourceFileModel sourceFile) throws IOException {
        String source = FileUtils.readFileToString((File)sourceFile.asFile());
        ArrayList<ClassReference> results = new ArrayList<ClassReference>();
        results.addAll(this.findImports(source));
        results.addAll(this.findTaglib(source));
        return results;
    }

    private List<ClassReference> findImports(String source) {
        ArrayList<ClassReference> results = new ArrayList<ClassReference>();
        Pattern jspImport = Pattern.compile("<%@\\s*page\\s+[^>]*\\s*import\\s*=\\s*['\"]([^'\"]+)['\"].*?%>", 34);
        Matcher matcher = jspImport.matcher(source);
        while (matcher.find()) {
            String[] imports;
            String matched = matcher.group(1);
            if (!StringUtils.isNotBlank((CharSequence)matched) || (imports = StringUtils.split((String)matched, (String)",")) == null) continue;
            for (String imported : imports) {
                if (!TypeInterestFactory.matchesAny((String)(imported = StringUtils.trim((String)imported)), (TypeReferenceLocation)TypeReferenceLocation.IMPORT)) continue;
                ClassReference reference = this.createClassReference(TypeReferenceLocation.IMPORT, source, imported, matcher.start());
                results.add(reference);
            }
        }
        return results;
    }

    private List<ClassReference> findTaglib(String source) {
        ArrayList<ClassReference> results = new ArrayList<ClassReference>();
        Pattern taglibPattern = Pattern.compile("<%@\\s*taglib\\s+[^>]*\\s*uri\\s*=\\s*['\"]([^'\"]+)['\"].*?%>", 34);
        Matcher matcher = taglibPattern.matcher(source);
        while (matcher.find()) {
            String matched = matcher.group(1);
            if (!StringUtils.isNotBlank((CharSequence)matched) || !TypeInterestFactory.matchesAny((String)matched, (TypeReferenceLocation)TypeReferenceLocation.TAGLIB_IMPORT)) continue;
            ClassReference reference = this.createClassReference(TypeReferenceLocation.TAGLIB_IMPORT, source, matched, matcher.start());
            results.add(reference);
        }
        return results;
    }

    private ClassReference createClassReference(TypeReferenceLocation location, String source, String reference, int startPosition) {
        String subString = StringUtils.substring((String)source, (int)0, (int)(startPosition + 1));
        String[] lines = subString.split("\r\n|\r|\n");
        int lineNumber = lines.length;
        int column = lines[lines.length - 1].indexOf(source.substring(startPosition));
        int length = reference.length();
        return new ClassReference(reference, null, null, null, ResolutionStatus.UNKNOWN, location, lineNumber, column, length, reference);
    }

    private class ParseSourceOperation
    extends AbstractIterationOperation<JspSourceFileModel> {
        private ParseSourceOperation() {
        }

        public void perform(GraphRewrite event, EvaluationContext context, JspSourceFileModel sourceFile) {
            TypeReferenceService typeReferenceService = new TypeReferenceService(event.getGraphContext());
            try {
                sourceFile.setPackageName("");
                sourceFile.setDecompiled(false);
                JavaClassService javaClassService = new JavaClassService(event.getGraphContext());
                JavaClassModel classModel = (JavaClassModel)javaClassService.create();
                classModel.setPackageName("");
                classModel.setSimpleName(sourceFile.getFileName());
                classModel.setQualifiedName(sourceFile.getFileName());
                classModel.setExtends(javaClassService.getOrCreatePhantom("javax.servlet.http.HttpServlet"));
                sourceFile.addJavaClass(classModel);
                Iterable references = AnalyzeJSPFileRuleProvider.this.getClassReferences(typeReferenceService, sourceFile);
                for (ClassReference reference : references) {
                    JavaTypeReferenceModel typeReference = typeReferenceService.createTypeReference((FileModel)sourceFile, reference.getLocation(), reference.getResolutionStatus(), reference.getLineNumber(), reference.getColumn(), reference.getLength(), reference.getQualifiedName(), reference.getLine());
                }
            }
            catch (Exception e) {
                ClassificationService classificationService = new ClassificationService(event.getGraphContext());
                classificationService.attachClassification(context, (FileModel)sourceFile, "Unparseable JSP File", "This JSP file could not be parsed");
            }
        }
    }
}

