/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules;

import java.util.HashMap;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.ReportGenerationPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.reporting.model.ApplicationReportModel;
import org.jboss.windup.reporting.model.ReportModel;
import org.jboss.windup.reporting.model.TemplateType;
import org.jboss.windup.reporting.model.WindupVertexListModel;
import org.jboss.windup.reporting.service.ApplicationReportService;
import org.jboss.windup.reporting.service.ReportService;
import org.jboss.windup.rules.apps.javaee.model.EjbRemoteServiceModel;
import org.jboss.windup.rules.apps.javaee.model.JaxRSWebServiceModel;
import org.jboss.windup.rules.apps.javaee.model.JaxWSWebServiceModel;
import org.jboss.windup.rules.apps.javaee.model.RMIServiceModel;
import org.jboss.windup.rules.apps.javaee.model.RemoteServiceModel;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class CreateRemoteReportRuleProvider
extends AbstractRuleProvider {
    public static final String TEMPLATE_EJB_REPORT = "/reports/templates/remote.ftl";

    public CreateRemoteReportRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(CreateRemoteReportRuleProvider.class, (String)"Create Remote Service Report").setPhase(ReportGenerationPhase.class));
    }

    public Configuration getConfiguration(GraphContext context) {
        return ConfigurationBuilder.begin().addRule().when((Condition)Query.fromType(RemoteServiceModel.class)).perform((Operation)new GraphOperation(){

            public void perform(GraphRewrite event, EvaluationContext context) {
                WindupConfigurationModel configurationModel = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext());
                ProjectModel projectModel = configurationModel.getInputPath().getProjectModel();
                CreateRemoteReportRuleProvider.this.createReport(event.getGraphContext(), projectModel);
            }

            public String toString() {
                return "CreateRemoteServiceReport";
            }
        });
    }

    private void createReport(GraphContext context, ProjectModel projectModel) {
        ApplicationReportService applicationReportService = new ApplicationReportService(context);
        ApplicationReportModel applicationReportModel = applicationReportService.create();
        applicationReportModel.setReportPriority(300);
        applicationReportModel.setDisplayInApplicationReportIndex(Boolean.valueOf(true));
        applicationReportModel.setReportName("Remote Services");
        applicationReportModel.setReportIconClass("glyphicon service-nav-logo");
        applicationReportModel.setProjectModel(projectModel);
        applicationReportModel.setTemplatePath(TEMPLATE_EJB_REPORT);
        applicationReportModel.setTemplateType(TemplateType.FREEMARKER);
        GraphService remoteServices = new GraphService(context, RemoteServiceModel.class);
        GraphService listService = new GraphService(context, WindupVertexListModel.class);
        WindupVertexListModel jaxRsList = (WindupVertexListModel)listService.create();
        WindupVertexListModel jaxWsList = (WindupVertexListModel)listService.create();
        WindupVertexListModel ejbRemoteList = (WindupVertexListModel)listService.create();
        WindupVertexListModel rmiList = (WindupVertexListModel)listService.create();
        for (RemoteServiceModel remoteServiceModel : remoteServices.findAll()) {
            if (remoteServiceModel instanceof JaxRSWebServiceModel) {
                jaxRsList.addItem((WindupVertexFrame)((JaxRSWebServiceModel)remoteServiceModel));
                continue;
            }
            if (remoteServiceModel instanceof JaxWSWebServiceModel) {
                jaxWsList.addItem((WindupVertexFrame)((JaxWSWebServiceModel)remoteServiceModel));
                continue;
            }
            if (remoteServiceModel instanceof EjbRemoteServiceModel) {
                ejbRemoteList.addItem((WindupVertexFrame)((EjbRemoteServiceModel)remoteServiceModel));
                continue;
            }
            if (!(remoteServiceModel instanceof RMIServiceModel)) continue;
            rmiList.addItem((WindupVertexFrame)((RMIServiceModel)remoteServiceModel));
        }
        HashMap<String, WindupVertexListModel> data = new HashMap<String, WindupVertexListModel>(4);
        data.put("jaxRsServices", jaxRsList);
        data.put("jaxWsServices", jaxWsList);
        data.put("ejbRemoteServices", ejbRemoteList);
        data.put("rmiServices", rmiList);
        applicationReportModel.setRelatedResource(data);
        ReportService reportService = new ReportService(context);
        reportService.setUniqueFilename((ReportModel)applicationReportModel, "remotereport_" + projectModel.getName(), "html");
    }
}

