/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules;

import com.thinkaurelius.titan.core.attribute.Text;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.FramedGraphQuery;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import com.tinkerpop.pipes.Pipe;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.query.QueryGremlinCriterion;
import org.jboss.windup.config.ruleprovider.IteratingRuleProvider;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.service.JavaClassService;
import org.jboss.windup.rules.apps.javaee.model.HibernateEntityModel;
import org.jboss.windup.rules.apps.javaee.model.HibernateMappingFileModel;
import org.jboss.windup.rules.apps.javaee.service.HibernateEntityService;
import org.jboss.windup.rules.apps.javaee.service.HibernateMappingFileService;
import org.jboss.windup.rules.apps.xml.model.DoctypeMetaModel;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.rules.apps.xml.service.XmlFileService;
import org.jboss.windup.util.xml.XmlUtil;
import org.joox.JOOX;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DiscoverHibernateMappingRuleProvider
extends IteratingRuleProvider<DoctypeMetaModel> {
    private static final Logger LOG = Logger.getLogger(DiscoverHibernateMappingRuleProvider.class.getSimpleName());
    private static final String TECH_TAG = "Hibernate Mapping";
    private static final TechnologyTagLevel TECH_TAG_LEVEL = TechnologyTagLevel.IMPORTANT;
    private static final String hibernateRegex = "(?i).*hibernate.mapping.*";

    public DiscoverHibernateMappingRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(DiscoverHibernateMappingRuleProvider.class).setPhase(InitialAnalysisPhase.class));
    }

    public String toStringPerform() {
        return "Discover hibernate.hbm.xml files";
    }

    public ConditionBuilder when() {
        QueryGremlinCriterion doctypeSearchCriterion = new QueryGremlinCriterion(){

            public void query(GraphRewrite event, GremlinPipeline<Vertex, Vertex> pipeline) {
                pipeline.has("DoctypeMeta:publicId", (Predicate)Text.REGEX, (Object)DiscoverHibernateMappingRuleProvider.hibernateRegex);
                FramedGraphQuery systemIDQuery = event.getGraphContext().getQuery().type(DoctypeMetaModel.class).has("DoctypeMeta:systemId", (Predicate)Text.REGEX, (Object)DiscoverHibernateMappingRuleProvider.hibernateRegex);
                GremlinPipeline systemIdPipeline = new GremlinPipeline((Object)systemIDQuery.vertices());
                pipeline.add((Pipe)systemIdPipeline);
                pipeline.dedup();
            }
        };
        return Query.fromType(DoctypeMetaModel.class).piped(doctypeSearchCriterion);
    }

    public void perform(GraphRewrite event, EvaluationContext context, DoctypeMetaModel payload) {
        JavaClassService javaClassService = new JavaClassService(event.getGraphContext());
        HibernateMappingFileService hibernateMappingFileService = new HibernateMappingFileService(event.getGraphContext());
        HibernateEntityService hibernateEntityService = new HibernateEntityService(event.getGraphContext());
        XmlFileService xmlFileService = new XmlFileService(event.getGraphContext());
        TechnologyTagService technologyTagService = new TechnologyTagService(event.getGraphContext());
        String publicId = payload.getPublicId();
        String systemId = payload.getSystemId();
        String versionInformation = this.extractVersion(publicId, systemId);
        for (XmlFileModel xml : payload.getXmlResources()) {
            HibernateMappingFileModel hibernateMapping = (HibernateMappingFileModel)hibernateMappingFileService.addTypeToModel((WindupVertexFrame)xml);
            Document doc = xmlFileService.loadDocumentQuiet(context, (XmlFileModel)hibernateMapping);
            if (!XmlUtil.xpathExists((Node)doc, (String)"/hibernate-mapping", null)) {
                LOG.log(Level.INFO, "Docment does not contain Hibernate Mapping.");
                continue;
            }
            String clzPkg = JOOX.$((Document)doc).xpath("/hibernate-mapping").attr("package");
            String clzName = JOOX.$((Document)doc).xpath("/hibernate-mapping/class").attr("name");
            String tableName = JOOX.$((Document)doc).xpath("/hibernate-mapping/class").attr("table");
            String schemaName = JOOX.$((Document)doc).xpath("/hibernate-mapping/class").attr("schema");
            String catalogName = JOOX.$((Document)doc).xpath("/hibernate-mapping/class").attr("catalog");
            if (StringUtils.isBlank((String)clzName)) {
                LOG.log(Level.FINE, "Docment does not contain class name. Skipping.");
                continue;
            }
            technologyTagService.addTagToFileModel((FileModel)xml, TECH_TAG, TECH_TAG_LEVEL);
            if (StringUtils.isNotBlank((String)clzPkg) && !StringUtils.startsWith((String)clzName, (String)clzPkg)) {
                clzName = clzPkg + "." + clzName;
            }
            JavaClassModel clz = javaClassService.getOrCreatePhantom(clzName);
            HibernateEntityModel hibernateEntity = (HibernateEntityModel)hibernateEntityService.create();
            hibernateEntity.setSpecificationVersion(versionInformation);
            hibernateEntity.setJavaClass(clz);
            hibernateEntity.setTableName(tableName);
            hibernateEntity.setSchemaName(schemaName);
            hibernateEntity.setCatalogName(catalogName);
            hibernateMapping.addHibernateEntity(hibernateEntity);
            if (!StringUtils.isNotBlank((String)versionInformation)) continue;
            hibernateEntity.setSpecificationVersion(versionInformation);
            hibernateMapping.setSpecificationVersion(versionInformation);
        }
    }

    private String extractVersion(String publicId, String systemId) {
        Matcher matcher;
        Pattern pattern = Pattern.compile("[0-9][0-9a-zA-Z.-]+");
        if (StringUtils.isNotBlank((String)publicId) && (matcher = pattern.matcher(publicId)).find()) {
            return matcher.group();
        }
        if (StringUtils.isNotBlank((String)systemId) && (matcher = pattern.matcher(systemId)).find()) {
            String match = matcher.group();
            return StringUtils.removeEnd((String)match, (String)".dtd");
        }
        return null;
    }
}

