/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.service;

import com.thinkaurelius.titan.core.attribute.Text;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import java.util.logging.Logger;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.javaee.model.RMIServiceModel;
import org.jboss.windup.util.Logging;

public class RMIServiceModelService
extends GraphService<RMIServiceModel> {
    private static Logger LOG = Logging.get(RMIServiceModelService.class);

    public RMIServiceModelService(GraphContext context) {
        super(context, RMIServiceModel.class);
    }

    public RMIServiceModel getOrCreate(JavaClassModel rmiInterface) {
        LOG.info("RMI Interface: " + rmiInterface.getQualifiedName());
        RMIServiceModel rmiServiceModel = this.findByInterface(rmiInterface);
        if (rmiServiceModel == null) {
            rmiServiceModel = (RMIServiceModel)this.create();
            rmiServiceModel.setInterface(rmiInterface);
            for (JavaClassModel implModel : rmiInterface.getImplementedBy()) {
                LOG.info(" -- Implementations: " + implModel.getQualifiedName());
                rmiServiceModel.setImplementationClass(implModel);
            }
        }
        return rmiServiceModel;
    }

    private RMIServiceModel findByInterface(JavaClassModel rmiInterface) {
        GremlinPipeline pipeline = new GremlinPipeline((Object)rmiInterface.asVertex());
        pipeline.in(new String[]{"rmiInterface"});
        pipeline.has("w:vertextype", (Predicate)Text.CONTAINS, (Object)"RMIService");
        if (pipeline.hasNext()) {
            return (RMIServiceModel)this.frame((Vertex)pipeline.next());
        }
        return null;
    }
}

