/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.pool.mcp;

import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPool;
import org.jboss.jca.core.connectionmanager.pool.mcp.SecurityActions;

class PoolFiller
implements Runnable {
    private static final PoolFiller FILLER = new PoolFiller();
    private final LinkedList<ManagedConnectionPool> pools = new LinkedList();
    private final Thread fillerThread;
    private static final String THREAD_FILLER_NAME = "JCA PoolFiller";
    private AtomicBoolean threadStarted = new AtomicBoolean(false);

    static void fillPool(ManagedConnectionPool mcp) {
        FILLER.internalFillPool(mcp);
    }

    PoolFiller() {
        this.fillerThread = new Thread((Runnable)this, THREAD_FILLER_NAME);
        this.fillerThread.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ClassLoader myClassLoader = this.getClass().getClassLoader();
        SecurityActions.setThreadContextClassLoader(myClassLoader);
        while (true) {
            Object mcp;
            boolean empty = false;
            while (!empty) {
                mcp = null;
                LinkedList<ManagedConnectionPool> linkedList = this.pools;
                synchronized (linkedList) {
                    empty = this.pools.isEmpty();
                    if (!empty) {
                        mcp = this.pools.removeFirst();
                    }
                }
                if (empty) continue;
                mcp.fillToMin();
            }
            try {
                mcp = this.pools;
                synchronized (mcp) {
                    while (this.pools.isEmpty()) {
                        this.pools.wait();
                    }
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalFillPool(ManagedConnectionPool mcp) {
        if (this.threadStarted.compareAndSet(false, true)) {
            this.fillerThread.start();
        }
        LinkedList<ManagedConnectionPool> linkedList = this.pools;
        synchronized (linkedList) {
            this.pools.addLast(mcp);
            this.pools.notifyAll();
        }
    }
}

