/*
 * Decompiled with CFR 0.152.
 */
package com.github.rwitzel.streamflyer.regex.addons.stateful;

import com.github.rwitzel.streamflyer.regex.MatchProcessor;
import com.github.rwitzel.streamflyer.regex.MatchProcessorResult;
import com.github.rwitzel.streamflyer.regex.addons.stateful.State;
import com.github.rwitzel.streamflyer.regex.addons.stateful.Transitions;
import com.github.rwitzel.streamflyer.regex.addons.util.DelegatingMatcher;
import java.util.regex.MatchResult;

public class StateMachine
implements MatchProcessor {
    private State currentState;
    private Transitions transitions;
    private DelegatingMatcher delegatingMatcher;

    public StateMachine(State initialState, DelegatingMatcher delegatingMatcher) {
        this.delegatingMatcher = delegatingMatcher;
        this.changeStateTo(initialState);
    }

    public State getCurrentState() {
        return this.currentState;
    }

    protected void changeStateTo(State state) {
        this.currentState = state;
        this.transitions = state.getTransitions();
        this.delegatingMatcher.setDelegate(state.getTransitions().getMatcher());
    }

    @Override
    public MatchProcessorResult process(StringBuilder characterBuffer, int firstModifiableCharacterInBuffer, MatchResult matchResult) {
        MatchProcessorResult result = this.transitions.process(characterBuffer, firstModifiableCharacterInBuffer, matchResult);
        State newState = this.transitions.pollNewState();
        if (newState != this.currentState) {
            this.changeStateTo(newState);
        }
        return result;
    }
}

