/*
 * Decompiled with CFR 0.152.
 */
package com.github.rwitzel.streamflyer.regex.addons.tokens;

import com.github.rwitzel.streamflyer.regex.OnStreamMatcher;
import com.github.rwitzel.streamflyer.regex.OnStreamStandardMatcher;
import com.github.rwitzel.streamflyer.regex.addons.tokens.Token;
import com.github.rwitzel.streamflyer.regex.addons.util.DelegatingMatcher;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TokensMatcher
extends DelegatingMatcher {
    public TokensMatcher() {
    }

    public TokensMatcher(List<Token> tokens) {
        this.setDelegate(this.createMatcher(this.createRegexThatMatchesAnyToken(tokens)));
    }

    String createRegexThatMatchesAnyToken(List<Token> tokens) {
        String regex = null;
        for (Token token : tokens) {
            if (regex == null) {
                regex = "(" + token.getRegex() + ")";
                continue;
            }
            regex = regex + "|(" + token.getRegex() + ")";
        }
        return regex;
    }

    protected OnStreamMatcher createMatcher(String regexTokenAlternatives) {
        Matcher matcher = Pattern.compile(regexTokenAlternatives, 0).matcher("");
        matcher.useTransparentBounds(true);
        matcher.useAnchoringBounds(false);
        return new OnStreamStandardMatcher(matcher);
    }
}

