/*
 * Decompiled with CFR 0.152.
 */
package com.github.rwitzel.streamflyer.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XmlVersionReader
extends BufferedReader {
    private String xmlVersion;

    public XmlVersionReader(Reader in) throws IOException {
        super(in);
        String prolog = this.prolog();
        this.xmlVersion = this.xmlVersion(prolog);
    }

    private String xmlVersion(String prolog) {
        Matcher matcher = Pattern.compile("<\\?xml[^>]*version\\s*=\\s*['\"]((1.0)|(1.1))['\"].*").matcher(prolog);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "1.0";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String prolog() throws IOException {
        int MAX_SNIFFED_CHARACTERS = 4096;
        this.mark(4096);
        try {
            char[] cbuf = new char[4096];
            int read = this.read(cbuf);
            if (read == -1) {
                String string = "";
                return string;
            }
            String string = new String(cbuf, 0, read);
            return string;
        }
        finally {
            this.reset();
        }
    }

    public String getXmlVersion() {
        return this.xmlVersion;
    }
}

