/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.result.navigation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.NavigationResultEntry;
import org.jboss.forge.addon.ui.result.navigation.ClassNavigationResultEntry;
import org.jboss.forge.addon.ui.result.navigation.CommandNavigationResultEntry;
import org.jboss.forge.addon.ui.result.navigation.CompositeNavigationResultEntry;
import org.jboss.forge.addon.ui.result.navigation.NavigationResultImpl;
import org.jboss.forge.addon.ui.wizard.UIWizard;

public final class NavigationResultBuilder {
    private List<NavigationResultEntry> entries = new LinkedList<NavigationResultEntry>();

    private NavigationResultBuilder() {
    }

    public static NavigationResultBuilder create() {
        return new NavigationResultBuilder();
    }

    public static NavigationResultBuilder create(NavigationResult result) {
        NavigationResultBuilder builder = new NavigationResultBuilder();
        if (result != null && result.getNext() != null) {
            builder.entries.addAll(Arrays.asList(result.getNext()));
        }
        return builder;
    }

    public NavigationResultBuilder add(Class<? extends UICommand> type) {
        this.entries.add(new ClassNavigationResultEntry(type));
        return this;
    }

    public NavigationResultBuilder add(UICommand command) {
        this.entries.add(new CommandNavigationResultEntry(command));
        return this;
    }

    public NavigationResultBuilder add(NavigationResult result) {
        if (result != null && result.getNext() != null) {
            this.entries.addAll(Arrays.asList(result.getNext()));
        }
        return this;
    }

    public NavigationResultBuilder add(UICommandMetadata metadata, Iterable<Class<? extends UICommand>> types) {
        ArrayList<NavigationResultEntry> internalEntries = new ArrayList<NavigationResultEntry>();
        for (Class<? extends UICommand> type : types) {
            if (UIWizard.class.isAssignableFrom(type)) {
                throw new IllegalArgumentException("A UICommand of type " + type + " was added. " + UIWizard.class.getSimpleName() + " instances should be added individually.");
            }
            internalEntries.add(new ClassNavigationResultEntry(type));
        }
        this.entries.add(new CompositeNavigationResultEntry(metadata, internalEntries));
        return this;
    }

    public NavigationResult build() {
        if (this.entries.isEmpty()) {
            return null;
        }
        return new NavigationResultImpl(this.entries);
    }
}

