/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.exec.configuration.options;

import java.io.File;
import java.nio.file.Path;
import org.jboss.windup.config.AbstractPathConfigurationOption;
import org.jboss.windup.config.InputType;
import org.jboss.windup.config.ValidationResult;

public class OutputPathOption
extends AbstractPathConfigurationOption {
    public static final String NAME = "output";

    public OutputPathOption() {
        super(false);
    }

    public String getName() {
        return NAME;
    }

    public String getLabel() {
        return "Output";
    }

    public String getDescription() {
        return "Output Directory (WARNING: any existing files will be removed)";
    }

    public InputType getUIType() {
        return InputType.DIRECTORY;
    }

    public boolean isRequired() {
        return false;
    }

    public int getPriority() {
        return 9000;
    }

    public static ValidationResult validateInputAndOutputPath(Path inputPath, Path outputPath) {
        File outputFile;
        File inputFile = inputPath.toFile();
        if (inputFile.equals(outputFile = outputPath.toFile())) {
            return new ValidationResult(ValidationResult.Level.ERROR, "Output file cannot be the same as the input file.");
        }
        for (File inputParent = inputFile.getParentFile(); inputParent != null; inputParent = inputParent.getParentFile()) {
            if (!inputParent.equals(outputFile)) continue;
            return new ValidationResult(ValidationResult.Level.ERROR, "Output path must not be a parent of input path.");
        }
        for (File outputParent = outputFile.getParentFile(); outputParent != null; outputParent = outputParent.getParentFile()) {
            if (!outputParent.equals(inputFile)) continue;
            return new ValidationResult(ValidationResult.Level.ERROR, "Input path must not be a parent of output path.");
        }
        return ValidationResult.SUCCESS;
    }
}

