/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractDoubleCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractObjectCollection;
import com.carrotsearch.hppc.DoubleContainer;
import com.carrotsearch.hppc.HashContainerUtils;
import com.carrotsearch.hppc.Internals;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectDoubleAssociativeContainer;
import com.carrotsearch.hppc.ObjectDoubleMap;
import com.carrotsearch.hppc.ObjectLookupContainer;
import com.carrotsearch.hppc.cursors.DoubleCursor;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectDoubleCursor;
import com.carrotsearch.hppc.predicates.DoublePredicate;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.procedures.DoubleProcedure;
import com.carrotsearch.hppc.procedures.ObjectDoubleProcedure;
import com.carrotsearch.hppc.procedures.ObjectProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ObjectDoubleOpenHashMap<KType>
implements ObjectDoubleMap<KType>,
Cloneable {
    public static final int MIN_CAPACITY = 4;
    public static final int DEFAULT_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public KType[] keys;
    public double[] values;
    public boolean[] allocated;
    public int assigned;
    public final float loadFactor;
    protected int resizeAt;
    protected int lastSlot;
    protected int perturbation;

    public ObjectDoubleOpenHashMap() {
        this(16);
    }

    public ObjectDoubleOpenHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ObjectDoubleOpenHashMap(int initialCapacity, float loadFactor) {
        initialCapacity = Math.max(initialCapacity, 4);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor <= 1.0f) : "Load factor must be between (0, 1].";
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainerUtils.roundCapacity(initialCapacity));
    }

    public ObjectDoubleOpenHashMap(ObjectDoubleAssociativeContainer<KType> container) {
        this((int)((float)container.size() * 1.75f));
        this.putAll(container);
    }

    @Override
    public double put(KType key, double value) {
        assert (this.assigned < this.allocated.length);
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (key == null ? this.keys[slot] == null : key.equals(this.keys[slot])) {
                double oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, value, slot);
        } else {
            ++this.assigned;
            this.allocated[slot] = true;
            this.keys[slot] = key;
            this.values[slot] = value;
        }
        return 0.0;
    }

    @Override
    public int putAll(ObjectDoubleAssociativeContainer<? extends KType> container) {
        int count = this.assigned;
        for (ObjectDoubleCursor<KType> objectDoubleCursor : container) {
            this.put(objectDoubleCursor.key, objectDoubleCursor.value);
        }
        return this.assigned - count;
    }

    @Override
    public int putAll(Iterable<? extends ObjectDoubleCursor<? extends KType>> iterable) {
        int count = this.assigned;
        for (ObjectDoubleCursor<KType> objectDoubleCursor : iterable) {
            this.put(objectDoubleCursor.key, objectDoubleCursor.value);
        }
        return this.assigned - count;
    }

    public boolean putIfAbsent(KType key, double value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    @Override
    public double putOrAdd(KType key, double putValue, double additionValue) {
        assert (this.assigned < this.allocated.length);
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (key == null ? this.keys[slot] == null : key.equals(this.keys[slot])) {
                this.values[slot] = this.values[slot] + additionValue;
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, putValue, slot);
        } else {
            ++this.assigned;
            this.allocated[slot] = true;
            this.keys[slot] = key;
            this.values[slot] = putValue;
        }
        return putValue;
    }

    @Override
    public double addTo(KType key, double additionValue) {
        return this.putOrAdd(key, additionValue, additionValue);
    }

    private void expandAndPut(KType pendingKey, double pendingValue, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (!this.allocated[freeSlot]);
        Object[] oldKeys = this.keys;
        double[] oldValues = this.values;
        boolean[] oldAllocated = this.allocated;
        this.allocateBuffers(HashContainerUtils.nextCapacity(this.keys.length));
        this.lastSlot = -1;
        ++this.assigned;
        oldAllocated[freeSlot] = true;
        oldKeys[freeSlot] = pendingKey;
        oldValues[freeSlot] = pendingValue;
        KType[] keys = this.keys;
        double[] values = this.values;
        boolean[] allocated = this.allocated;
        int mask = allocated.length - 1;
        int i = oldAllocated.length;
        while (--i >= 0) {
            if (!oldAllocated[i]) continue;
            Object k = oldKeys[i];
            double v = oldValues[i];
            int slot = Internals.rehash(k, this.perturbation) & mask;
            while (allocated[slot]) {
                slot = slot + 1 & mask;
            }
            allocated[slot] = true;
            keys[slot] = k;
            values[slot] = v;
        }
        Arrays.fill(oldKeys, null);
    }

    private void allocateBuffers(int capacity) {
        Object[] keys = (Object[])Internals.newArray(capacity);
        double[] values = new double[capacity];
        boolean[] allocated = new boolean[capacity];
        this.keys = keys;
        this.values = values;
        this.allocated = allocated;
        this.resizeAt = Math.max(2, (int)Math.ceil((float)capacity * this.loadFactor)) - 1;
        this.perturbation = this.computePerturbationValue(capacity);
    }

    protected int computePerturbationValue(int capacity) {
        return HashContainerUtils.PERTURBATIONS[Integer.numberOfLeadingZeros(capacity)];
    }

    @Override
    public double remove(KType key) {
        int slot;
        int mask = this.allocated.length - 1;
        int wrappedAround = slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (key == null ? this.keys[slot] == null : key.equals(this.keys[slot])) {
                --this.assigned;
                double v = this.values[slot];
                this.shiftConflictingKeys(slot);
                return v;
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
            break;
        }
        return 0.0;
    }

    protected void shiftConflictingKeys(int slotCurr) {
        int mask = this.allocated.length - 1;
        while (true) {
            int slotPrev = slotCurr;
            slotCurr = slotPrev + 1 & mask;
            while (this.allocated[slotCurr]) {
                int slotOther = Internals.rehash(this.keys[slotCurr], this.perturbation) & mask;
                if (slotPrev <= slotCurr ? slotPrev >= slotOther || slotOther > slotCurr : slotPrev >= slotOther && slotOther > slotCurr) break;
                slotCurr = slotCurr + 1 & mask;
            }
            if (!this.allocated[slotCurr]) break;
            this.keys[slotPrev] = this.keys[slotCurr];
            this.values[slotPrev] = this.values[slotCurr];
        }
        this.allocated[slotPrev] = false;
        this.keys[slotPrev] = null;
    }

    @Override
    public int removeAll(ObjectContainer<? extends KType> container) {
        int before = this.assigned;
        for (ObjectCursor<KType> objectCursor : container) {
            this.remove(objectCursor.value);
        }
        return before - this.assigned;
    }

    @Override
    public int removeAll(ObjectPredicate<? super KType> predicate) {
        int before = this.assigned;
        KType[] keys = this.keys;
        boolean[] states = this.allocated;
        int i = 0;
        while (i < states.length) {
            if (states[i] && predicate.apply(keys[i])) {
                --this.assigned;
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.assigned;
    }

    @Override
    public double get(KType key) {
        int slot;
        int mask = this.allocated.length - 1;
        int wrappedAround = slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (key == null ? this.keys[slot] == null : key.equals(this.keys[slot])) {
                return this.values[slot];
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
            break;
        }
        return 0.0;
    }

    @Override
    public double getOrDefault(KType key, double defaultValue) {
        int slot;
        int mask = this.allocated.length - 1;
        int wrappedAround = slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (key == null ? this.keys[slot] == null : key.equals(this.keys[slot])) {
                return this.values[slot];
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
            break;
        }
        return defaultValue;
    }

    public KType lkey() {
        return this.keys[this.lslot()];
    }

    public double lget() {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        return this.values[this.lastSlot];
    }

    public double lset(double key) {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        double previous = this.values[this.lastSlot];
        this.values[this.lastSlot] = key;
        return previous;
    }

    public int lslot() {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        return this.lastSlot;
    }

    @Override
    public boolean containsKey(KType key) {
        int slot;
        int mask = this.allocated.length - 1;
        int wrappedAround = slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (key == null ? this.keys[slot] == null : key.equals(this.keys[slot])) {
                this.lastSlot = slot;
                return true;
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
        }
        this.lastSlot = -1;
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        Arrays.fill(this.allocated, false);
        Arrays.fill(this.keys, null);
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (ObjectDoubleCursor<KType> c : this) {
            h += Internals.rehash(c.key) + Internals.rehash(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            ObjectDoubleMap other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof ObjectDoubleMap && (other = (ObjectDoubleMap)obj).size() == this.size()) {
                for (ObjectDoubleCursor<KType> c : this) {
                    if (other.containsKey(c.key)) {
                        double v = other.get(c.key);
                        if (Double.doubleToLongBits(c.value) == Double.doubleToLongBits(v)) continue;
                    }
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<ObjectDoubleCursor<KType>> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends ObjectDoubleProcedure<? super KType>> T forEach(T procedure) {
        KType[] keys = this.keys;
        double[] values = this.values;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            procedure.apply(keys[i], values[i]);
        }
        return procedure;
    }

    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public DoubleContainer values() {
        return new ValuesContainer();
    }

    public ObjectDoubleOpenHashMap<KType> clone() {
        try {
            ObjectDoubleOpenHashMap cloned = (ObjectDoubleOpenHashMap)super.clone();
            cloned.keys = (Object[])this.keys.clone();
            cloned.values = (double[])this.values.clone();
            cloned.allocated = (boolean[])this.allocated.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (ObjectDoubleCursor<KType> cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static <KType> ObjectDoubleOpenHashMap<KType> from(KType[] keys, double[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectDoubleOpenHashMap<KType> map = new ObjectDoubleOpenHashMap<KType>();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static <KType> ObjectDoubleOpenHashMap<KType> from(ObjectDoubleAssociativeContainer<KType> container) {
        return new ObjectDoubleOpenHashMap<KType>(container);
    }

    public static <KType> ObjectDoubleOpenHashMap<KType> newInstance() {
        return new ObjectDoubleOpenHashMap<KType>();
    }

    public static <KType> ObjectDoubleOpenHashMap<KType> newInstanceWithoutPerturbations() {
        return new ObjectDoubleOpenHashMap<KType>(){

            @Override
            protected int computePerturbationValue(int capacity) {
                return 0;
            }
        };
    }

    public static <KType> ObjectDoubleOpenHashMap<KType> newInstance(int initialCapacity, float loadFactor) {
        return new ObjectDoubleOpenHashMap<KType>(initialCapacity, loadFactor);
    }

    public static <KType> ObjectDoubleOpenHashMap<KType> newInstanceWithExpectedSize(int expectedSize) {
        return ObjectDoubleOpenHashMap.newInstanceWithExpectedSize(expectedSize, 0.75f);
    }

    public static <KType> ObjectDoubleOpenHashMap<KType> newInstanceWithExpectedSize(int expectedSize, float loadFactor) {
        return ObjectDoubleOpenHashMap.newInstance((int)((float)expectedSize / loadFactor) + 1, loadFactor);
    }

    private final class ValuesIterator
    extends AbstractIterator<DoubleCursor> {
        private final DoubleCursor cursor = new DoubleCursor();

        public ValuesIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected DoubleCursor fetch() {
            int i;
            int max = ObjectDoubleOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !ObjectDoubleOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (DoubleCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ObjectDoubleOpenHashMap.this.values[i];
            return this.cursor;
        }
    }

    private final class ValuesContainer
    extends AbstractDoubleCollection {
        private ValuesContainer() {
        }

        @Override
        public int size() {
            return ObjectDoubleOpenHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ObjectDoubleOpenHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(double value) {
            boolean[] allocated = ObjectDoubleOpenHashMap.this.allocated;
            double[] values = ObjectDoubleOpenHashMap.this.values;
            for (int slot = 0; slot < allocated.length; ++slot) {
                if (!allocated[slot] || Double.doubleToLongBits(value) != Double.doubleToLongBits(values[slot])) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends DoubleProcedure> T forEach(T procedure) {
            boolean[] allocated = ObjectDoubleOpenHashMap.this.allocated;
            double[] values = ObjectDoubleOpenHashMap.this.values;
            for (int i = 0; i < allocated.length; ++i) {
                if (!allocated[i]) continue;
                procedure.apply(values[i]);
            }
            return procedure;
        }

        @Override
        public <T extends DoublePredicate> T forEach(T predicate) {
            boolean[] allocated = ObjectDoubleOpenHashMap.this.allocated;
            double[] values = ObjectDoubleOpenHashMap.this.values;
            for (int i = 0; i < allocated.length && (!allocated[i] || predicate.apply(values[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public Iterator<DoubleCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAllOccurrences(double e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int removeAll(DoublePredicate predicate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor = new ObjectCursor();

        public KeysIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            int i;
            int max = ObjectDoubleOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !ObjectDoubleOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (ObjectCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ObjectDoubleOpenHashMap.this.keys[i];
            return this.cursor;
        }
    }

    public final class KeysContainer
    extends AbstractObjectCollection<KType>
    implements ObjectLookupContainer<KType> {
        private final ObjectDoubleOpenHashMap<KType> owner;

        public KeysContainer() {
            this.owner = ObjectDoubleOpenHashMap.this;
        }

        @Override
        public boolean contains(KType e) {
            return ObjectDoubleOpenHashMap.this.containsKey(e);
        }

        @Override
        public <T extends ObjectProcedure<? super KType>> T forEach(T procedure) {
            KType[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length; ++i) {
                if (!localStates[i]) continue;
                procedure.apply(localKeys[i]);
            }
            return procedure;
        }

        @Override
        public <T extends ObjectPredicate<? super KType>> T forEach(T predicate) {
            KType[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length && (!localStates[i] || predicate.apply(localKeys[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ObjectCursor<KType>> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(ObjectPredicate<? super KType> predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAllOccurrences(KType e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<ObjectDoubleCursor<KType>> {
        private final ObjectDoubleCursor<KType> cursor = new ObjectDoubleCursor();

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected ObjectDoubleCursor<KType> fetch() {
            int i;
            int max = ObjectDoubleOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !ObjectDoubleOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (ObjectDoubleCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = ObjectDoubleOpenHashMap.this.keys[i];
            this.cursor.value = ObjectDoubleOpenHashMap.this.values[i];
            return this.cursor;
        }
    }
}

