/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.queries;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.RandomAccessOrds;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;

public class SortedSetSortField
extends SortField {
    private final Selector selector;

    public SortedSetSortField(String field, boolean reverse) {
        this(field, reverse, Selector.MIN);
    }

    public SortedSetSortField(String field, boolean reverse, Selector selector) {
        super(field, SortField.Type.CUSTOM, reverse);
        if (selector == null) {
            throw new NullPointerException();
        }
        this.selector = selector;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public int hashCode() {
        return 31 * super.hashCode() + this.selector.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SortedSetSortField other = (SortedSetSortField)((Object)obj);
        return this.selector == other.selector;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<sortedset: \"").append(this.getField()).append("\">");
        if (this.getReverse()) {
            buffer.append('!');
        }
        if (this.missingValue != null) {
            buffer.append(" missingValue=");
            buffer.append(this.missingValue);
        }
        buffer.append(" selector=");
        buffer.append((Object)this.selector);
        return buffer.toString();
    }

    public void setMissingValue(Object missingValue) {
        if (missingValue != STRING_FIRST && missingValue != STRING_LAST) {
            throw new IllegalArgumentException("For SORTED_SET type, missing value must be either STRING_FIRST or STRING_LAST");
        }
        this.missingValue = missingValue;
    }

    public FieldComparator<?> getComparator(int numHits, int sortPos) throws IOException {
        return new FieldComparator.TermOrdValComparator(numHits, this.getField(), this.missingValue == STRING_LAST){

            protected SortedDocValues getSortedDocValues(AtomicReaderContext context, String field) throws IOException {
                SortedSetDocValues sortedSet = FieldCache.DEFAULT.getDocTermOrds(context.reader(), field);
                if (sortedSet.getValueCount() >= Integer.MAX_VALUE) {
                    throw new UnsupportedOperationException("fields containing more than 2147483646 unique terms are unsupported");
                }
                SortedDocValues singleton = DocValues.unwrapSingleton((SortedSetDocValues)sortedSet);
                if (singleton != null) {
                    return singleton;
                }
                if (SortedSetSortField.this.selector == Selector.MIN) {
                    return new MinValue(sortedSet);
                }
                if (!(sortedSet instanceof RandomAccessOrds)) {
                    throw new UnsupportedOperationException("codec does not support random access ordinals, cannot use selector: " + (Object)((Object)SortedSetSortField.this.selector));
                }
                RandomAccessOrds randomOrds = (RandomAccessOrds)sortedSet;
                switch (SortedSetSortField.this.selector) {
                    case MAX: {
                        return new MaxValue(randomOrds);
                    }
                    case MIDDLE_MIN: {
                        return new MiddleMinValue(randomOrds);
                    }
                    case MIDDLE_MAX: {
                        return new MiddleMaxValue(randomOrds);
                    }
                }
                throw new AssertionError();
            }
        };
    }

    static class MiddleMaxValue
    extends SortedDocValues {
        final RandomAccessOrds in;

        MiddleMaxValue(RandomAccessOrds in) {
            this.in = in;
        }

        public int getOrd(int docID) {
            this.in.setDocument(docID);
            int count = this.in.cardinality();
            if (count == 0) {
                return -1;
            }
            return (int)this.in.ordAt(count >>> 1);
        }

        public void lookupOrd(int ord, BytesRef result) {
            this.in.lookupOrd((long)ord, result);
        }

        public int getValueCount() {
            return (int)this.in.getValueCount();
        }

        public int lookupTerm(BytesRef key) {
            return (int)this.in.lookupTerm(key);
        }
    }

    static class MiddleMinValue
    extends SortedDocValues {
        final RandomAccessOrds in;

        MiddleMinValue(RandomAccessOrds in) {
            this.in = in;
        }

        public int getOrd(int docID) {
            this.in.setDocument(docID);
            int count = this.in.cardinality();
            if (count == 0) {
                return -1;
            }
            return (int)this.in.ordAt(count - 1 >>> 1);
        }

        public void lookupOrd(int ord, BytesRef result) {
            this.in.lookupOrd((long)ord, result);
        }

        public int getValueCount() {
            return (int)this.in.getValueCount();
        }

        public int lookupTerm(BytesRef key) {
            return (int)this.in.lookupTerm(key);
        }
    }

    static class MaxValue
    extends SortedDocValues {
        final RandomAccessOrds in;

        MaxValue(RandomAccessOrds in) {
            this.in = in;
        }

        public int getOrd(int docID) {
            this.in.setDocument(docID);
            int count = this.in.cardinality();
            if (count == 0) {
                return -1;
            }
            return (int)this.in.ordAt(count - 1);
        }

        public void lookupOrd(int ord, BytesRef result) {
            this.in.lookupOrd((long)ord, result);
        }

        public int getValueCount() {
            return (int)this.in.getValueCount();
        }

        public int lookupTerm(BytesRef key) {
            return (int)this.in.lookupTerm(key);
        }
    }

    static class MinValue
    extends SortedDocValues {
        final SortedSetDocValues in;

        MinValue(SortedSetDocValues in) {
            this.in = in;
        }

        public int getOrd(int docID) {
            this.in.setDocument(docID);
            return (int)this.in.nextOrd();
        }

        public void lookupOrd(int ord, BytesRef result) {
            this.in.lookupOrd((long)ord, result);
        }

        public int getValueCount() {
            return (int)this.in.getValueCount();
        }

        public int lookupTerm(BytesRef key) {
            return (int)this.in.lookupTerm(key);
        }
    }

    public static enum Selector {
        MIN,
        MAX,
        MIDDLE_MIN,
        MIDDLE_MAX;

    }
}

