/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.projects.impl;

import java.util.List;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.DependencyQuery;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.dependencies.builder.DependencyQueryBuilder;
import org.jboss.forge.addon.dependencies.util.NonSnapshotDependencyFilter;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.DependencyFacet;
import org.jboss.forge.furnace.util.Predicate;
import org.jboss.forge.furnace.util.Strings;

public class DependencyInstallerImpl
implements DependencyInstaller {
    public Dependency install(Project project, Dependency request) {
        DependencyFacet deps = (DependencyFacet)project.getFacet(DependencyFacet.class);
        Dependency dependency = deps.resolveProperties(request);
        Dependency unversioned = this.getUnversioned(dependency);
        Dependency existing = deps.getEffectiveDependency(unversioned);
        Dependency existingManaged = deps.getEffectiveManagedDependency(unversioned);
        if (existing != null) {
            if (!Strings.isNullOrEmpty((String)existing.getCoordinate().getVersion()) && (existing.getCoordinate().getVersion().equals(dependency.getCoordinate().getVersion()) || Strings.isNullOrEmpty((String)dependency.getCoordinate().getVersion()))) {
                return existing;
            }
            return this.updateAll(deps, dependency, unversioned);
        }
        if (existingManaged != null) {
            if (!Strings.isNullOrEmpty((String)existingManaged.getCoordinate().getVersion()) && (existingManaged.getCoordinate().getVersion().equals(dependency.getCoordinate().getVersion()) || Strings.isNullOrEmpty((String)dependency.getCoordinate().getVersion()))) {
                deps.removeDependency(dependency);
                this.updateDependency(deps, unversioned);
                return existingManaged;
            }
            return this.updateAll(deps, dependency, unversioned);
        }
        Dependency toInstall = dependency;
        if (Strings.isNullOrEmpty((String)dependency.getCoordinate().getVersion())) {
            List versions = deps.resolveAvailableVersions((DependencyQuery)DependencyQueryBuilder.create((Coordinate)dependency.getCoordinate()).setFilter((Predicate)new NonSnapshotDependencyFilter()));
            if (versions.isEmpty()) {
                versions = deps.resolveAvailableVersions((DependencyQuery)DependencyQueryBuilder.create((Coordinate)dependency.getCoordinate()));
            }
            if (!versions.isEmpty()) {
                toInstall = DependencyBuilder.create((Dependency)dependency).setVersion(((Coordinate)versions.get(versions.size() - 1)).getVersion());
            } else {
                throw new IllegalStateException("Could not resolve version for dependency [" + dependency.getCoordinate() + "].");
            }
        }
        return this.updateAll(deps, toInstall, unversioned);
    }

    private Dependency getUnversioned(Dependency dependency) {
        return DependencyBuilder.create((Dependency)dependency).setVersion(null).setOptional(dependency.isOptional());
    }

    public Dependency installManaged(Project project, Dependency dependency) {
        DependencyFacet deps = (DependencyFacet)project.getFacet(DependencyFacet.class);
        this.updateManagedDependency(deps, dependency);
        return dependency;
    }

    public boolean isInstalled(Project project, Dependency dependency) {
        DependencyFacet deps = (DependencyFacet)project.getFacet(DependencyFacet.class);
        return deps.hasEffectiveDependency(dependency);
    }

    public boolean isManaged(Project project, Dependency dependency) {
        DependencyFacet deps = (DependencyFacet)project.getFacet(DependencyFacet.class);
        return deps.hasEffectiveManagedDependency(dependency);
    }

    private Dependency updateAll(DependencyFacet deps, Dependency requested, Dependency unversioned) {
        this.updateDependency(deps, unversioned);
        this.updateManagedDependency(deps, requested);
        return requested;
    }

    private void updateManagedDependency(DependencyFacet deps, Dependency dependency) {
        deps.addDirectManagedDependency(dependency);
    }

    private void updateDependency(DependencyFacet deps, Dependency dependency) {
        deps.addDirectDependency(dependency);
    }
}

