/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.util;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.EntryMetaData;
import com.thinkaurelius.titan.diskstorage.MetaAnnotatable;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.util.BaseStaticArrayEntry;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayBuffer;
import com.thinkaurelius.titan.graphdb.relations.RelationCache;
import java.nio.ByteBuffer;
import java.util.Map;

public class StaticArrayEntry
extends BaseStaticArrayEntry
implements Entry,
MetaAnnotatable {
    private Map<EntryMetaData, Object> metadata = EntryMetaData.EMPTY_METADATA;
    private volatile transient RelationCache cache;
    public static final EntryMetaData[] EMPTY_SCHEMA = new EntryMetaData[0];
    public static GetColVal<Entry, StaticBuffer> ENTRY_GETTER = new GetColVal<Entry, StaticBuffer>(){

        @Override
        public StaticBuffer getColumn(Entry entry) {
            return entry.getColumn();
        }

        @Override
        public StaticBuffer getValue(Entry entry) {
            return entry.getValue();
        }

        @Override
        public EntryMetaData[] getMetaSchema(Entry element) {
            if (!element.hasMetaData()) {
                return EMPTY_SCHEMA;
            }
            Map<EntryMetaData, Object> metas = element.getMetaData();
            return metas.keySet().toArray(new EntryMetaData[metas.size()]);
        }

        @Override
        public Object getMetaData(Entry element, EntryMetaData meta) {
            return element.getMetaData().get((Object)meta);
        }
    };

    public StaticArrayEntry(byte[] array, int offset, int limit, int valuePosition) {
        super(array, offset, limit, valuePosition);
    }

    public StaticArrayEntry(byte[] array, int limit, int valuePosition) {
        super(array, limit, valuePosition);
    }

    public StaticArrayEntry(byte[] array, int valuePosition) {
        super(array, valuePosition);
    }

    public StaticArrayEntry(StaticBuffer buffer, int valuePosition) {
        super(buffer, valuePosition);
    }

    StaticArrayEntry(Entry entry) {
        super(entry, entry.getValuePosition());
    }

    @Override
    public synchronized Object setMetaData(EntryMetaData key, Object value) {
        if (this.metadata == EntryMetaData.EMPTY_METADATA) {
            this.metadata = new EntryMetaData.Map();
        }
        return this.metadata.put(key, value);
    }

    @Override
    public boolean hasMetaData() {
        return !this.metadata.isEmpty();
    }

    @Override
    public Map<EntryMetaData, Object> getMetaData() {
        return this.metadata;
    }

    @Override
    public RelationCache getCache() {
        return this.cache;
    }

    @Override
    public void setCache(RelationCache cache) {
        Preconditions.checkNotNull((Object)cache);
        this.cache = cache;
    }

    public static Entry of(StaticBuffer buffer) {
        return new StaticArrayEntry(buffer, buffer.length());
    }

    public static final <E> Entry ofBytes(E element, GetColVal<E, byte[]> getter) {
        return StaticArrayEntry.of(element, getter, ByteArrayHandler.INSTANCE);
    }

    public static final <E> Entry ofByteBuffer(E element, GetColVal<E, ByteBuffer> getter) {
        return StaticArrayEntry.of(element, getter, ByteBufferHandler.INSTANCE);
    }

    public static final <E> Entry ofStaticBuffer(E element, GetColVal<E, StaticBuffer> getter) {
        return StaticArrayEntry.of(element, getter, StaticBufferHandler.INSTANCE);
    }

    public static final <E> Entry of(StaticBuffer column, StaticBuffer value) {
        return StaticArrayEntry.of(column, value, StaticBufferHandler.INSTANCE);
    }

    private static final <E, D> Entry of(E element, GetColVal<E, D> getter, DataHandler<D> datahandler) {
        StaticArrayEntry entry = StaticArrayEntry.of(getter.getColumn(element), getter.getValue(element), datahandler);
        if (getter.getMetaSchema(element).length > 0) {
            for (EntryMetaData meta : getter.getMetaSchema(element)) {
                entry.setMetaData(meta, getter.getMetaData(element, meta));
            }
        }
        return entry;
    }

    private static final <E, D> StaticArrayEntry of(D column, D value, DataHandler<D> datahandler) {
        int valuePos = datahandler.getSize(column);
        byte[] data = new byte[valuePos + datahandler.getSize(value)];
        datahandler.copy(column, data, 0);
        datahandler.copy(value, data, valuePos);
        return new StaticArrayEntry(data, valuePos);
    }

    static enum StaticBufferHandler implements DataHandler<StaticBuffer>
    {
        INSTANCE;


        @Override
        public int getSize(StaticBuffer data) {
            return data.length();
        }

        @Override
        public void copy(StaticBuffer data, byte[] dest, int destOffset) {
            if (!(data instanceof StaticArrayBuffer)) {
                throw new IllegalArgumentException("Expected StaticArrayBuffer but got: " + data.getClass());
            }
            StaticArrayBuffer buffer = (StaticArrayBuffer)data;
            buffer.copyTo(dest, destOffset);
        }
    }

    static enum ByteBufferHandler implements DataHandler<ByteBuffer>
    {
        INSTANCE;


        @Override
        public int getSize(ByteBuffer data) {
            return data.remaining();
        }

        @Override
        public void copy(ByteBuffer data, byte[] dest, int destOffset) {
            if (data.hasArray()) {
                System.arraycopy(data.array(), data.arrayOffset() + data.position(), dest, destOffset, data.remaining());
            } else {
                data.mark();
                data.get(dest, destOffset, data.remaining());
                data.reset();
            }
        }
    }

    static enum ByteArrayHandler implements DataHandler<byte[]>
    {
        INSTANCE;


        @Override
        public int getSize(byte[] data) {
            return data.length;
        }

        @Override
        public void copy(byte[] data, byte[] dest, int destOffset) {
            System.arraycopy(data, 0, dest, destOffset, data.length);
        }
    }

    public static interface DataHandler<D> {
        public int getSize(D var1);

        public void copy(D var1, byte[] var2, int var3);
    }

    public static interface GetColVal<E, D> {
        public D getColumn(E var1);

        public D getValue(E var1);

        public EntryMetaData[] getMetaSchema(E var1);

        public Object getMetaData(E var1, EntryMetaData var2);
    }
}

