/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query.vertex;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.graphdb.internal.OrderList;
import com.thinkaurelius.titan.graphdb.query.BackendQueryHolder;
import com.thinkaurelius.titan.graphdb.query.BaseQuery;
import com.thinkaurelius.titan.graphdb.query.QueryUtil;
import com.thinkaurelius.titan.graphdb.query.condition.Condition;
import com.thinkaurelius.titan.graphdb.query.condition.FixedCondition;
import com.tinkerpop.blueprints.Direction;
import java.util.ArrayList;
import java.util.List;

public class BaseVertexCentricQuery
extends BaseQuery {
    protected final Condition<TitanRelation> condition;
    protected final List<BackendQueryHolder<SliceQuery>> queries;
    private final OrderList orders;
    protected final Direction direction;

    public BaseVertexCentricQuery(Condition<TitanRelation> condition, Direction direction, List<BackendQueryHolder<SliceQuery>> queries, OrderList orders, int limit) {
        super(limit);
        Preconditions.checkArgument((condition != null && queries != null && direction != null ? 1 : 0) != 0);
        Preconditions.checkArgument((QueryUtil.isQueryNormalForm(condition) && limit >= 0 ? 1 : 0) != 0);
        this.condition = condition;
        this.queries = queries;
        this.orders = orders;
        this.direction = direction;
    }

    protected BaseVertexCentricQuery(BaseVertexCentricQuery query) {
        this(query.getCondition(), query.getDirection(), query.getQueries(), query.getOrders(), query.getLimit());
    }

    protected BaseVertexCentricQuery() {
        this(new FixedCondition<TitanRelation>(false), Direction.BOTH, new ArrayList<BackendQueryHolder<SliceQuery>>(0), OrderList.NO_ORDER, 0);
    }

    public static BaseVertexCentricQuery emptyQuery() {
        return new BaseVertexCentricQuery();
    }

    public Condition<TitanRelation> getCondition() {
        return this.condition;
    }

    public OrderList getOrders() {
        return this.orders;
    }

    public Direction getDirection() {
        return this.direction;
    }

    protected List<BackendQueryHolder<SliceQuery>> getQueries() {
        return this.queries;
    }

    public boolean isEmpty() {
        return this.getLimit() <= 0;
    }

    public int numSubQueries() {
        return this.queries.size();
    }

    public boolean isSimple() {
        return this.queries.size() == 1 && this.queries.get(0).isFitted() && this.queries.get(0).isSorted();
    }

    public BackendQueryHolder<SliceQuery> getSubQuery(int position) {
        return this.queries.get(position);
    }

    public boolean matches(TitanRelation relation) {
        return this.condition.evaluate(relation);
    }

    public String toString() {
        String s = "[" + this.condition.toString() + "]";
        if (this.hasLimit()) {
            s = s + ":" + this.getLimit();
        }
        return s;
    }
}

