/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.impl.input;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.forge.addon.convert.ConverterFactory;
import org.jboss.forge.addon.environment.Environment;
import org.jboss.forge.addon.facets.Facet;
import org.jboss.forge.addon.ui.annotation.Option;
import org.jboss.forge.addon.ui.facets.HintsFacet;
import org.jboss.forge.addon.ui.impl.facets.HintsFacetImpl;
import org.jboss.forge.addon.ui.impl.input.UIInputImpl;
import org.jboss.forge.addon.ui.impl.input.UIInputManyImpl;
import org.jboss.forge.addon.ui.impl.input.UISelectManyImpl;
import org.jboss.forge.addon.ui.impl.input.UISelectOneImpl;
import org.jboss.forge.addon.ui.impl.input.inject.DefaultInputComponentInjectionPoint;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.InputComponentInjectionEnricher;
import org.jboss.forge.addon.ui.input.SelectComponent;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.input.UISelectMany;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.input.inject.InputComponentInjectionPoint;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.util.InputComponents;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.services.Imported;

@Singleton
public class InputComponentProducer
implements InputComponentFactory {
    private final AddonRegistry addonRegistry;
    private final Environment environment;
    private final ConverterFactory converterFactory;
    private final Imported<InputComponentInjectionEnricher> deprecatedEnrichers;
    private final Imported<org.jboss.forge.addon.ui.input.inject.InputComponentInjectionEnricher> enrichers;

    @Inject
    public InputComponentProducer(AddonRegistry addonRegistry) {
        this.addonRegistry = addonRegistry;
        this.environment = (Environment)addonRegistry.getServices(Environment.class).get();
        this.converterFactory = (ConverterFactory)addonRegistry.getServices(ConverterFactory.class).get();
        this.enrichers = addonRegistry.getServices(org.jboss.forge.addon.ui.input.inject.InputComponentInjectionEnricher.class);
        this.deprecatedEnrichers = addonRegistry.getServices(InputComponentInjectionEnricher.class);
    }

    @Produces
    public <T> UISelectOne<T> produceSelectOne(InjectionPoint injectionPoint) {
        Class valueType;
        String name = injectionPoint.getMember().getName();
        Annotated annotated = injectionPoint.getAnnotated();
        Type type = annotated.getBaseType();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            valueType = this.resolveRealType(typeArguments[0]);
        } else {
            valueType = String.class;
        }
        WithAttributes withAttributes = (WithAttributes)annotated.getAnnotation(WithAttributes.class);
        String paramName = withAttributes == null || withAttributes.name().trim().isEmpty() ? name : withAttributes.name();
        char shortName = withAttributes == null ? (char)' ' : (char)withAttributes.shortName();
        UISelectOne<String> input = this.createSelectOne(paramName, shortName, valueType);
        input.setDeprecated(annotated.isAnnotationPresent(Deprecated.class));
        this.preconfigureInput((InputComponent<?, ?>)input, withAttributes);
        this.enrichInput(injectionPoint, (InputComponent<?, ?>)input);
        return input;
    }

    @Produces
    public <T> UISelectMany<T> produceSelectMany(InjectionPoint injectionPoint) {
        Class valueType;
        String name = injectionPoint.getMember().getName();
        Annotated annotated = injectionPoint.getAnnotated();
        Type type = annotated.getBaseType();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            valueType = this.resolveRealType(typeArguments[0]);
        } else {
            valueType = String.class;
        }
        WithAttributes withAttributes = (WithAttributes)annotated.getAnnotation(WithAttributes.class);
        String paramName = withAttributes == null || withAttributes.name().trim().isEmpty() ? name : withAttributes.name();
        char shortName = withAttributes == null ? (char)' ' : (char)withAttributes.shortName();
        UISelectMany<String> input = this.createSelectMany(paramName, shortName, valueType);
        input.setDeprecated(annotated.isAnnotationPresent(Deprecated.class));
        this.preconfigureInput((InputComponent<?, ?>)input, withAttributes);
        this.enrichInput(injectionPoint, (InputComponent<?, ?>)input);
        return input;
    }

    @Produces
    public <T> UIInput<T> produceInput(InjectionPoint injectionPoint) {
        Class valueType;
        String name = injectionPoint.getMember().getName();
        Annotated annotated = injectionPoint.getAnnotated();
        Type type = annotated.getBaseType();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            valueType = this.resolveRealType(typeArguments[0]);
        } else {
            valueType = String.class;
        }
        WithAttributes withAttributes = (WithAttributes)annotated.getAnnotation(WithAttributes.class);
        String paramName = withAttributes == null || withAttributes.name().trim().isEmpty() ? name : withAttributes.name();
        char shortName = withAttributes == null ? (char)' ' : (char)withAttributes.shortName();
        UIInput<String> input = this.createInput(paramName, shortName, valueType);
        input.setDeprecated(annotated.isAnnotationPresent(Deprecated.class));
        this.preconfigureInput((InputComponent<?, ?>)input, withAttributes);
        this.enrichInput(injectionPoint, (InputComponent<?, ?>)input);
        return input;
    }

    @Produces
    public <T> UIInputMany<T> produceInputMany(InjectionPoint injectionPoint) {
        Class valueType;
        String name = injectionPoint.getMember().getName();
        Annotated annotated = injectionPoint.getAnnotated();
        Type type = annotated.getBaseType();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            valueType = this.resolveRealType(typeArguments[0]);
        } else {
            valueType = String.class;
        }
        WithAttributes withAttributes = (WithAttributes)annotated.getAnnotation(WithAttributes.class);
        String paramName = withAttributes == null || withAttributes.name().trim().isEmpty() ? name : withAttributes.name();
        char shortName = withAttributes == null ? (char)' ' : (char)withAttributes.shortName();
        UIInputMany<String> input = this.createInputMany(paramName, shortName, valueType);
        input.setDeprecated(annotated.isAnnotationPresent(Deprecated.class));
        this.preconfigureInput((InputComponent<?, ?>)input, withAttributes);
        this.enrichInput(injectionPoint, (InputComponent<?, ?>)input);
        return input;
    }

    public <T> UIInput<T> createInput(String name, Class<T> valueType) {
        return this.createInput(name, ' ', valueType);
    }

    public <T> UIInputMany<T> createInputMany(String name, Class<T> valueType) {
        return this.createInputMany(name, ' ', valueType);
    }

    public <T> UISelectOne<T> createSelectOne(String name, Class<T> valueType) {
        return this.createSelectOne(name, ' ', valueType);
    }

    public <T> UISelectMany<T> createSelectMany(String name, Class<T> valueType) {
        return this.createSelectMany(name, ' ', valueType);
    }

    private <T> Class<T> resolveRealType(Type type) {
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getRawType();
        }
        return (Class)type;
    }

    public <T> UIInput<T> createInput(String name, char shortName, Class<T> valueType) {
        UIInputImpl<T> input = new UIInputImpl<T>(name, shortName, valueType);
        this.configureRequiredFacets(input);
        if (Boolean.class.equals(valueType) || Boolean.TYPE.equals(valueType)) {
            input.setDefaultValue(Boolean.FALSE);
        }
        return input;
    }

    public <T> UIInputMany<T> createInputMany(String name, char shortName, Class<T> valueType) {
        UIInputManyImpl<T> input = new UIInputManyImpl<T>(name, shortName, valueType);
        this.configureRequiredFacets(input);
        return input;
    }

    public <T> UISelectOne<T> createSelectOne(String name, char shortName, Class<T> valueType) {
        UISelectOneImpl<T> input = new UISelectOneImpl<T>(name, shortName, valueType);
        this.setupSelectComponent(input);
        this.configureRequiredFacets(input);
        return input;
    }

    public <T> UISelectMany<T> createSelectMany(String name, char shortName, Class<T> valueType) {
        UISelectManyImpl<T> input = new UISelectManyImpl<T>(name, shortName, valueType);
        this.setupSelectComponent(input);
        this.configureRequiredFacets(input);
        return input;
    }

    public void preconfigureInput(InputComponent<?, ?> input, WithAttributes atts) {
        if (atts != null) {
            input.setEnabled(atts.enabled());
            input.setLabel(atts.label());
            input.setRequired(atts.required());
            input.setRequiredMessage(atts.requiredMessage());
            input.setDescription(atts.description());
            input.setDeprecated(atts.deprecated());
            input.setDeprecatedMessage(atts.deprecatedMessage());
            if (!"org.jboss.forge.inputType.DEFAULT".equals(atts.type())) {
                ((HintsFacet)input.getFacet(HintsFacet.class)).setInputType(atts.type());
            }
            if (!atts.defaultValue().isEmpty()) {
                InputComponents.setDefaultValueFor((ConverterFactory)this.converterFactory, input, (Object)atts.defaultValue());
            }
            if (!atts.note().isEmpty()) {
                input.setNote(atts.note());
            }
        }
    }

    public void preconfigureInput(InputComponent<?, ?> input, Option option) {
        if (option != null) {
            input.setEnabled(option.enabled());
            if (option.label().isEmpty()) {
                input.setLabel(option.value());
            } else {
                input.setLabel(option.label());
            }
            input.setRequired(option.required());
            input.setRequiredMessage(option.requiredMessage());
            input.setDescription(option.description());
            input.setDeprecated(option.deprecated());
            input.setDeprecatedMessage(option.deprecatedMessage());
            if (!"org.jboss.forge.inputType.DEFAULT".equals(option.type())) {
                ((HintsFacet)input.getFacet(HintsFacet.class)).setInputType(option.type());
            }
            if (!option.defaultValue().isEmpty()) {
                InputComponents.setDefaultValueFor((ConverterFactory)this.converterFactory, input, (Object)option.defaultValue());
            }
            if (!option.note().isEmpty()) {
                input.setNote(option.note());
            }
        }
    }

    public void setupSelectComponent(SelectComponent selectComponent) {
        Class valueType = selectComponent.getValueType();
        Object choices = null;
        if (valueType.isEnum()) {
            Class<Enum> enumClass = valueType.asSubclass(Enum.class);
            choices = EnumSet.allOf(enumClass);
        } else {
            choices = Boolean.class == valueType || Boolean.TYPE == valueType ? Arrays.asList(Boolean.TRUE, Boolean.FALSE) : (String.class == valueType || Integer.class == valueType ? Collections.emptyList() : this.addonRegistry.getServices(valueType));
        }
        selectComponent.setValueChoices(choices);
    }

    private <T> void enrichInput(InjectionPoint injectionPoint, InputComponent<?, ?> input) {
        for (InputComponentInjectionEnricher enricher : this.deprecatedEnrichers) {
            enricher.enrich(injectionPoint, input);
        }
        DefaultInputComponentInjectionPoint inputInjectionPoint = DefaultInputComponentInjectionPoint.of(injectionPoint);
        for (org.jboss.forge.addon.ui.input.inject.InputComponentInjectionEnricher enricher : this.enrichers) {
            enricher.enrich((InputComponentInjectionPoint)inputInjectionPoint, input);
        }
    }

    private void configureRequiredFacets(InputComponent<?, ?> input) {
        HintsFacetImpl hintsFacet = new HintsFacetImpl(input, this.environment);
        input.install((Facet)hintsFacet);
    }
}

