/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.impl.validate;

import java.util.Collection;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.util.InputComponents;
import org.jboss.forge.addon.ui.validate.UIValidationListener;
import org.jboss.forge.furnace.util.Strings;

public class DeprecationWarningValidationListener
implements UIValidationListener {
    public void preValidate(UIValidationContext context, UICommand command, Collection<InputComponent<?, ?>> inputs) {
    }

    public void postValidate(UIValidationContext context, UICommand command, Collection<InputComponent<?, ?>> inputs) {
        UIContext uiContext = context.getUIContext();
        UICommandMetadata metadata = command.getMetadata(uiContext);
        if (metadata.isDeprecated()) {
            String msg = String.format("The command '%s' is deprecated and will be removed in future versions.", metadata.getName());
            if (!Strings.isNullOrEmpty((String)metadata.getDeprecatedMessage())) {
                msg = msg + " " + metadata.getDeprecatedMessage();
            }
            context.addValidationWarning(null, msg);
        }
        for (InputComponent<?, ?> input : inputs) {
            if (!input.isEnabled() || !input.isDeprecated() || !input.hasValue()) continue;
            String name = uiContext.getProvider().isGUI() ? InputComponents.getLabelFor(input, (boolean)false) : input.getName();
            String msg = String.format("The parameter '%s' from command '%s' is deprecated and will be removed in future versions.", name, metadata.getName());
            if (!Strings.isNullOrEmpty((String)input.getDeprecatedMessage())) {
                msg = msg + " " + input.getDeprecatedMessage();
            }
            context.addValidationWarning(input, msg);
        }
    }
}

